;-------------------------------------------------------------------------------
; IDL function to return union, differenct, and intersection values of two
; arrays. This routines are from FSC website
; (http://www.dfanning.com/tips/set_operations.html)
;
; NAME  
;    match
; USAGE 
;    r = match(a,b[,/difference,/union][,index='sort array histogram']   
; INPUT  
;    a,b : arrays
; KEYWORD
;    intersection : find values which are in array A and in array B
;    difference   : find values which are in array A and not in array B
;    union        : find values which are in array A or in array B
;    index        : returns index (intersection only)
;                   can use different methods for indexing (JD Smith)
;
; RETURN
;    values or index
;
; wrapped by Hyun Cheol Kim 20060405
;-------------------------------------------------------------------------------

FUNCTION SetUnion, a, b

IF a[0] LT 0 THEN RETURN, b    ;A union NULL = a
IF b[0] LT 0 THEN RETURN, a    ;B union NULL = b
RETURN, Where(Histogram([a,b], OMin = omin)) + omin ; Return combined set

END
;...............................................................................

FUNCTION SetIntersection, a, b

minab = Min(a, Max=maxa) > Min(b, Max=maxb) ;Only need intersection of ranges
maxab = maxa < maxb

   ; If either set is empty, or their ranges don't intersect: result = NULL.

IF maxab LT minab OR maxab LT 0 THEN RETURN, -1
r = Where((Histogram(a, Min=minab, Max=maxab) NE 0) AND  $
          (Histogram(b, Min=minab, Max=maxab) NE 0), count)

IF count EQ 0 THEN RETURN, -1 ELSE RETURN, r + minab

END
;...............................................................................

FUNCTION SetDifference, a, b  

   ; = a and (not b) = elements in A but not in B

mina = Min(a, Max=maxa)
minb = Min(b, Max=maxb)
IF (minb GT maxa) OR (maxb LT mina) THEN RETURN, a ;No intersection...
r = Where((Histogram(a, Min=mina, Max=maxa) NE 0) AND $
          (Histogram(b, Min=mina, Max=maxa) EQ 0), count)
IF count eq 0 THEN RETURN, -1 ELSE RETURN, r + mina

END
;...............................................................................

function ind_int_SORT, a, b

   flag=[replicate(0b,n_elements(a)),replicate(1b,n_elements(b))]
   s=[a,b]
   srt=sort(s)
   s=s[srt] & flag=flag[srt]
   wh=where(s eq shift(s,-1) and flag ne shift(flag, -1),cnt)
   if cnt eq 0 then return, -1
   return,srt[wh]

end
;...............................................................................

function ind_int_ARRAY, a, b

   Na = n_elements(a)           
   Nb = n_elements(b)
   l = lindgen(Na,Nb)
   AA = A(l mod Na)
   BB = B(l / Na)
   
   ;;compare the two matrices we just created
   I = where(AA eq BB,cnt)
   if cnt eq 0 then return,-1
   return,I mod Na

end
;...............................................................................

function ind_int_HISTOGRAM, a, b

   minab = min(a, MAX=maxa) > min(b, MAX=maxb) 
   maxab = maxa < maxb
   ha = histogram(a, MIN=minab, MAX=maxab, reverse_indices=reva)
   hb = histogram(b, MIN=minab, MAX=maxab)
   r = where((ha ne 0) and (hb ne 0), cnt)
   if cnt eq 0 then return, -1
   return,reva[reva[r]]

end
;-------------------------------------------------------------------------------

 function match,a,b,intersection=intersection,union=union,difference=difference,$
          index=index
					
;-------------------------------------------------------------------------------

if keyword_set(index) then begin

  index = string(index)

  case 1 of

    index eq 'SORT'      : return,ind_int_SORT(a,b)
    index eq 'ARRAY'     : return,ind_int_ARRAY(a,b)
    index eq 'HISTOGRAM' : return,ind_int_HISTOGRAM(a,b)
    else                 : return,ind_int_SORT(a,b)
  
  endcase
  
endif else begin

  case 1 of
    
    keyword_set(intersection) : return,setintersection(a,b)
    keyword_set(union)        : return,setunion(a,b)
    keyword_set(difference)   : return,Setdifference(a,b)
    else                      : return,setintersection(a,b)

  endcase

endelse  

end



