;-------------------------------------------------------------------------------
;	NAME
;		map_3points
;
;	PURPOSE
;		To calculate area over earth with 3 points
;
;	USAGE
;		r = map_3points(lon,lat)
;
;	INPUT
;		lon : longitudes	
;		lat : latitudes
;		radius : Earth radius. Default is 6370000d
;
;	AUTHOR
;		20121206 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function map_3points,_lon,_lat,radius=r
	
;-------------------------------------------------------------------------------

if ~var_set(r) then r = 6370000d

lon = _lon*!dtor
lat = _lat*!dtor

la = 2*asin(sqrt((sin((lat[0,*]-lat[1,*])/2d))^2+cos(lat[0,*])*cos(lat[1,*])*(sin((lon[0,*]-lon[1,*])/2d))^2))
lb = 2*asin(sqrt((sin((lat[1,*]-lat[2,*])/2d))^2+cos(lat[1,*])*cos(lat[2,*])*(sin((lon[1,*]-lon[2,*])/2d))^2))
lc = 2*asin(sqrt((sin((lat[2,*]-lat[0,*])/2d))^2+cos(lat[2,*])*cos(lat[0,*])*(sin((lon[2,*]-lon[0,*])/2d))^2))

s = (la+lb+lc)/2d

area = 4d*atan(sqrt(tan(s/2d)*tan((s-la)/2d)*tan((s-lb)/2d)*tan((s-lc)/2d)))*r^2

return,area

end
