;-------------------------------------------------------------------------------
;	NAME
;		linetrack
;
;	PURPOSE
;		returns 4d indices of polyine tracking path
;
;	USAGE
;		ii = linetrack(x,y,z,t,dim=[nx,ny,nz,nt],[olen=])
;
;	INPUT
;		x,y,z,t : location,alt and time (normalized)
;		dim     : dimension
;		
;	OUTPUT
;		olen : polyline length outputs
;
;	AUTHOR
;		2014-08-27 Hyun Cheol Kim (hyun.kim@noaa.gov) rewritten
;-------------------------------------------------------------------------------

	function linetrack,_x,_y,_z,_t,dim=dim,olen=olen
	
;-------------------------------------------------------------------------------

if total([var_set(_x),var_set(_y),var_set(_z),var_set(_t)]) ne (ndim=n_elements(dim)) then message,str(/join,'wrong DIM (USAGE: lineclip(x,y[,z,t],dim=[sx,sy[,sz,st]]')
if max(_x,min=_xmin) lt 0 or _xmin gt dim[0]-1 or max(_y,min=_ymin) lt 0 or _ymin gt dim[1]-1  then return,-1
if ndim ge 3 then if max(_z,min=_zmin) lt 0 or _zmin gt dim[2]-1 then return,-1
if ndim ge 4 then if max(_t,min=_tmin) lt 0 or _tmin gt dim[3]-1 then return,-1

x = double(_x)-(xmin=floor(_xmin)<0)
y = double(_y)-(ymin=floor(_ymin)<0)
if ndim ge 3 then z = double(_z)-(zmin=floor(_zmin)<0)
if ndim ge 4 then t = double(_t)-(tmin=floor(_tmin)<0)

nxx = (dim[0]-xmin) > ceil(max(x))
nyy = (dim[1]-ymin) > ceil(max(y))
if ndim ge 3 then nzz = (dim[2]-zmin) > ceil(max(z))
if ndim ge 4 then ntt = (dim[3]-tmin) > ceil(max(t))

tag = long(x)+nxx*long(y)+(ndim ge 3 ? nxx*nyy*long(z) : 0)+(ndim ge 4 ? nxx*nyy*nzz*long(t) :0)
	
for ix=0L,n_elements(x)-2 do begin

	if tag[ix] eq tag[ix+1] then begin
	
		ll = [var_set(ll) ? ll : !null ,sqrt((x[ix]-x[ix+1])^2+(y[ix]-y[ix+1])^2+(ndim ge 3 ? (z[ix]-z[ix+1])^2 : 0))]
		tg = [var_set(tg) ? tg : !null,tag[ix]] 
					
	endif else begin
		
		xx = [x[ix],x[ix+1]]
		yy = [y[ix],y[ix+1]]
		if ndim ge 3 then zz = [z[ix],z[ix+1]]
		if ndim ge 4 then tt = [t[ix],t[ix+1]]
												
		if floor(x[ix]) ne floor(x[ix+1]) then begin
		
			xx = [xx,(xx1=ceil(x[ix]<x[ix+1])+indgen(floor(x[ix]>x[ix+1])-ceil(x[ix]<x[ix+1])+1))]
			yy = [yy,(y[ix]-y[ix+1])/(x[ix]-x[ix+1])*(xx1-x[ix])+y[ix]]
			if ndim ge 3 then zz = [zz,(z[ix]-z[ix+1])/(x[ix]-x[ix+1])*(xx1-x[ix])+z[ix]]
			if ndim ge 4 then tt = [tt,(t[ix]-t[ix+1])/(x[ix]-x[ix+1])*(xx1-x[ix])+t[ix]]
						
		endif
				
		if floor(y[ix]) ne floor(y[ix+1]) then begin
			
			yy = [yy,(yy1=ceil(y[ix]<y[ix+1])+indgen(floor(y[ix]>y[ix+1])-ceil(y[ix]<y[ix+1])+1))]
			xx = [xx,(x[ix]-x[ix+1])/(y[ix]-y[ix+1])*(yy1-y[ix])+x[ix]]
			if ndim ge 3 then zz = [zz,(z[ix]-z[ix+1])/(y[ix]-y[ix+1])*(yy1-y[ix])+z[ix]]
			if ndim ge 4 then tt = [tt,(t[ix]-t[ix+1])/(y[ix]-y[ix+1])*(yy1-y[ix])+t[ix]]
									
		endif
		
		if ndim ge 3 then if floor(z[ix]) ne floor(z[ix+1]) then begin
		
			zz = [zz,(zz1=ceil(z[ix]<z[ix+1])+indgen(floor(z[ix]>z[ix+1])-ceil(z[ix]<z[ix+1])+1))]								
			xx = [xx,(x[ix]-x[ix+1])/(z[ix]-z[ix+1])*(zz1-z[ix])+x[ix]]
			yy = [yy,(y[ix]-y[ix+1])/(z[ix]-z[ix+1])*(zz1-z[ix])+y[ix]]
			if ndim ge 4 then tt = [tt,(t[ix]-t[ix+1])/(z[ix]-z[ix+1])*(zz1-z[ix])+t[ix]]
						
		endif
		
		if ndim ge 4 then if floor(t[ix]) ne floor(t[ix+1]) then begin
		
			tt = [tt,(tt1=ceil(t[ix]<t[ix+1])+indgen(floor(t[ix]>t[ix+1])-ceil(t[ix]<t[ix+1])+1))]								
			xx = [xx,(x[ix]-x[ix+1])/(t[ix]-t[ix+1])*(tt1-t[ix])+x[ix]]
			yy = [yy,(y[ix]-y[ix+1])/(t[ix]-t[ix+1])*(tt1-t[ix])+y[ix]]
			zz = [zz,(z[ix]-z[ix+1])/(t[ix]-t[ix+1])*(tt1-t[ix])+z[ix]]
						
		endif
												
		xx = xx[(ixx = sort((xx-xx[0])^2+(yy-yy[0])^2+(ndim ge 3 ? (zz-zz[0])^2 : 0)+(ndim ge 4 ? (tt-tt[0])^2 : 0)))]
		yy = yy[ixx]
		if ndim ge 3 then zz = zz[ixx]
		if ndim ge 4 then tt = tt[ixx]
				
		ll1 = sqrt((xx[1:*]-xx)^2+(yy[1:*]-yy)^2+(ndim ge 3 ? (zz[1:*]-zz)^2 : 0))
		tg1 = floor(((xx2=xx[1:*]+xx)/2d))+nxx*floor(((yy2=yy[1:*]+yy)/2d))+(ndim ge 3 ? nxx*nyy*floor(((zz2=zz[1:*]+zz)/2d)) : 0)+(ndim ge 4 ? nxx*nyy*nzz*floor(((tt2=tt[1:*]+tt)/2d)) : 0)
		
		ll = [var_set(ll) ? ll : !null,ll1]
		tg = [var_set(tg) ? tg : !null,tg1]
													
	endelse

endfor

ill = array_indices(ndim eq 4 ? [nxx,nyy,nzz,ntt] : ndim eq 3 ? [nxx,nyy,nzz] : [nxx,nyy],tg,/dim)
ixx = reform(ill[0,*])+xmin
iyy = reform(ill[1,*])+ymin
if ndim ge 3 then izz = reform(ill[2,*])+zmin
if ndim ge 4 then itt = reform(ill[3,*])+tmin

ill = ixx+dim[0]*iyy+(ndim ge 3 ? dim[0]*dim[1]*izz : 0)+(ndim ge 4 ? dim[0]*dim[1]*dim[2]*itt : 0)
ill = data_check(ill,ixx lt 0 or ixx ge dim[0] or iyy lt 0 or iyy ge dim[1] or (ndim ge 3 ? izz lt 0 or izz ge dim[2] : 0b) or (ndim ge 4 ? itt lt 0 or itt ge dim[3] : 0b) or (olen=ll) eq 0,-1)

return,struct_make('ii',ill,'ix',ixx,'iy',iyy,'iz',izz,'it',itt)
end
