;-------------------------------------------------------------------------------
;	NAME
;		ii_m3
;	
;	PURPOSE
;		ro return M3 data information
;
;	USAGE
;		ii = ii_m3(file)
;
;	INPUT
;		file : m3 files
;
;	AUTHOR
;		2014-02-11 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2015-08-21 modified tstep checking
;-------------------------------------------------------------------------------

	function ii_m3_file1,file
		
;-------------------------------------------------------------------------------

catch,error_status
if error_status ne 0 then begin & catch,cancel & return,!null & endif

cdf_id = ncdf_open(file[0])						
						
ncdf_diminq,cdf_id,ncdf_dimid(cdf_id,'TSTEP'),dim_name,ntime
ncdf_diminq,cdf_id,ncdf_dimid(cdf_id,'LAY'),  dim_name,nlays

ncdf_attget,cdf_id,/global,'XCENT',xcent
ncdf_attget,cdf_id,/global,'YCENT',ycent
ncdf_attget,cdf_id,/global,'P_ALP',p_alp
ncdf_attget,cdf_id,/global,'P_BET',p_bet    
ncdf_attget,cdf_id,/global,'XORIG',xorig
ncdf_attget,cdf_id,/global,'YORIG',yorig
ncdf_attget,cdf_id,/global,'XCELL',xcell
ncdf_attget,cdf_id,/global,'YCELL',ycell
ncdf_attget,cdf_id,/global,'NCOLS',ncols
ncdf_attget,cdf_id,/global,'NROWS',nrows						
ncdf_attget,cdf_id,/global,'SDATE',sdate
ncdf_attget,cdf_id,/global,'STIME',stime
ncdf_attget,cdf_id,/global,'TSTEP',tstep					
ncdf_attget,cdf_id,/global,'VAR-LIST',varlist
ncdf_attget,cdf_id,/global,'VGLVLS',sigma
			
ncdf_close,cdf_id

	; tflag, var & minfo
					
case 1 of

	ntime eq 0 : tflag = ''
	stime eq 0 and tstep eq 0 : tflag = ''
	else : begin
	
		tstep = str(tstep,digit=6)
		tstep = double([strmid(tstep,0,2),strmid(tstep,2,2),strmid(tstep,4,2)])	
		tflag = date_j2t(timegen(ntime,start=date_t2j(strmid(date(sdate),0,8)+str(stime,digit=6)),step_size=(tstep[0]/(24d)+tstep[1]/(60d*24d)+tstep[2]/(3600d*24d))))
																						
		case 1 of
				
			tstep[2] gt 0 : tflag = str(/join,strmid(tflag,0,14))
			tstep[1] gt 0 : tflag = str(/join,strmid(tflag,0,12))
			tstep[0] gt 0 : tflag = str(/join,strmid(tflag,0,10))
			else : tflag = ''					
				
		endcase	
		end

endcase
			
if tflag eq '' then ntime = 0L

var   = string(reform(varlist,[16,n_elements(varlist)/16]))
minfo = {lon0:xcent,lat0:ycent,lat1:p_alp,lat2:p_bet,x0:xorig,y0:yorig,dx:xcell,dy:ycell,nx:ncols,ny:nrows}

return,{file:file,minfo:minfo,tflag:tflag,ntime:ntime,var:str(/join,var),nvar:n_elements(var),sigma:str(/join,sigma),nz:nlays}
end
;-------------------------------------------------------------------------------

	function ii_m3,file,ominfo=ominfo,otflag=otflag
	
;-------------------------------------------------------------------------------

for ifile=0L,n_elements(file)-1 do ii = [var_set(ii) ? ii : !null,ii_m3_file1(file[ifile])]

if arg_present(ominfo) then ominfo = ii[0].minfo
if arg_present(otflag) then otflag = ary(strsplit(str(/join,ii.tflag),/extract),/uniq)
		
return,ii
end
