;-------------------------------------------------------------------------------
;	NAME
;		grp
;
;	PURPOSE
;		Calculate mean (and more) for same group id
;	
;	USAGE
;		r = grp(gr1,[data],ogrp=grp2)
;
;	INPUT
;		gr1  : group id
;		data : data array
;
;	KEYWORD
;		method : choose calcualtion method ('mean','total','sum','stddev','first',
;                        'mean','max','min','dominant','median','count','fraction','moment'  
;
;	OUTPUT
;
;
;	NOTE
;		Rewritten from grouping.pro (also, see remap.pro for the earliest version)
;
;	AUTHOR
;		2012-05-16 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2012-09-13 added /moment
;-------------------------------------------------------------------------------

	function stddev2,data,nan_stddev=nan_stddev
	
;-------------------------------------------------------------------------------

dd = stddev(data)

if var_set(nan_stddev) then dd = data_check(dd,~finite(dd),nan_stddev)
		
return,dd

end
;-------------------------------------------------------------------------------

	function grp,_gr1,_data,n1,n2,method=method,missing=missing,index=index,$
	         domain=domain,minfo=minfo,z=z,struct_add=struct_add,$
	         nan_stddev=nan_stddev,ogrp=gr2,oindex=oid	         
	
;-------------------------------------------------------------------------------

	; remove missing

data = var_set(_data) ? ( n_elements(_data) lt n_elements(_gr1) ? array(_data,count=n_elements(_gr1)) : _data) : replicate(1,n_elements(_gr1))
gr1  = var_set(missing) ? data_check(_gr1,data ne missing) : _gr1
data = var_set(missing) ? data_check(data,data ne missing) : data
if ~var_set(missing) then missing = -999d

	; early exit and defaults
	
if n_elements(gr1) eq 1 then begin & gr2 = gr1 & oid = 0LL & return,data & endif
if ~var_set(method) then if var_set(_data) then method = 'total' else method = 'count'

	; get uniq group id
				
xgr1 = keyword_set(index) ? gr1 : idx(gr1,/self,oself=gr2)

	; grouping by histogram

h = histogram(xgr1,omin=min,reverse_indices=ri)
x = where(h ne 0,nx)

if ~var_set(gr2) then gr2 = x+min

	; error check

if n_elements(gr2) ne nx then message

	; set outputs and main loop
	
rr  = dblarr(nx)
oid = lonarr(nx)

for ix=0LL,nx-1 do begin

	oid[ix] = ri[ri[x[ix]]]

	case str(/low,method) of
	
		'total'    : rr[ix] = total(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'sum'      : rr[ix] = total(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'stddev'   : rr[ix] = stddev2(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],nan_stddev=nan_stddev)
		'first'    : rr[ix] = data[ri[ri[x[ix]]]]
		'mean'     : rr[ix] = mean(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'max'      : begin & rr[ix] = max(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],imax) & oid[ix] = (ri[ri[x[ix]]:ri[x[ix]+1]-1])[imax] & end
		'min'      : begin & rr[ix] = min(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],imin) & oid[ix] = (ri[ri[x[ix]]:ri[x[ix]+1]-1])[imin] & end
		'dominant' : rr[ix] = array(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],/dominant)
		'median'   : rr[ix] = median(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'count'    : rr[ix] = ri[x[ix]+1]-ri[x[ix]]
		'fraction' : rr[ix] = double(idx(idx(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],n1,/contain),/count))/(ri[x[ix]+1]-ri[x[ix]])
		'moment'   : begin
					
			if ~struct_set(missing) then missing = {mean:-999d,stddev:-999d,n:0L}			
			if  struct_set(struct_add) then missing = struct_merge(missing,struct_add)						
			if ~struct_set(rr) then rr = replicate(missing,nx)
																	
			rr1 = {mean:double(mean(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])),stddev:double(stddev2(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],nan_stddev=nan_stddev)),n:long(ri[x[ix]+1]-ri[x[ix]])}

			if var_set(struct_add) then rr1 = create_struct(rr1,struct_add)
						
			rr[ix] = rr1

			end
			
			
						
	endcase

endfor

	; domain
	
if var_set(domain,minfo,/if_any) then begin
	
	minfo = aqm_grid_minfo(domain=domain,minfo=minfo)
	
	rr2 = var_set(z) ? replicate(missing,[minfo.nx,minfo.ny,z]) : replicate(missing,[minfo.nx,minfo.ny])
	xx  = var_set(z) ? where(gr2 ge 0 and gr2 lt minfo.nx*minfo.ny*z,nxx) : where(gr2 ge 0 and gr2 lt minfo.nx*minfo.ny,nxx)
		
	if nxx gt 0 then rr2[gr2[xx]] = rr[xx]
	
	rr  = temporary(rr2)	
	oid = struct_set(rr) ? where(rr.n ne missing.n) : where(rr ne missing)

endif

	;

return,rr

end
