;-------------------------------------------------------------------------------
;	NAME
;		grouping
;
;	PURPOSE	
;		calculate mean (and more) for same group id
;
;	USAGE
;		r = regroup(data,group1,ogroup=group2)
;
;	INPUT
;		method : grouping method
;		data   : data
;		group1 : original group id
;
;	KEYWORD
;		N/A
;
;	OUTPUT
;		ogroup : uniq group id returned
;
;	AUTHOR
;		2010-08-12 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2011-06-20 added time, it can return 3d gridded output
;-------------------------------------------------------------------------------

	function grouping,method,_data,_gr1,n1,n2,n3,ogroup=gr2,oindex=oid,$
	         domain=domain,minfo=minfo,time=time,missing=missing
	
;-------------------------------------------------------------------------------

	; remove missing
	
data = var_set(missing) ? data_check(_data,_data ne missing) : _data
gr1  = var_set(missing) ? data_check(_gr1,_data ne missing) : _gr1

	; handle string

gr1_is_string = size(gr1,/type) eq 7

if n_elements(gr1) eq 1 then gr2 = gr1
if n_elements(gr1) eq 1 then oid = 0L
if n_elements(gr1) eq 1 then return,data

if gr1_is_string then gr1_temp = array(gr1,/uniq)
if gr1_is_string then gr1 = (lindgen(n_elements(gr1_temp)))[index(reform([gr1_temp]),reform([gr1]),/point,/first)] 

	; get histogram

h = histogram(gr1,omin=min,reverse_indices=ri)
x = where(h ne 0,nx)

	; outputs

rrr = dblarr(nx)
gr2 = make_array(nx,type=size(gr1,/type))
oid = lonarr(nx)

	; main loop

for ix=0L,nx-1 do begin

	gr2[ix] = gr1[ri[ri[x[ix]]]]
	oid[ix] = ri[ri[x[ix]]]
	
	case str(/up,method) of
	
		'TOTAL'    : rrr[ix] = total(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'SUM'      : rrr[ix] = total(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'FIRST'    : rrr[ix] = data[ri[ri[x[ix]]]]
		'MEAN'     : rrr[ix] = mean(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'MAX'      : rrr[ix] = max(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],imax)
		'MIN'      : rrr[ix] = min(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],imin)
		'DOMINANT' : rrr[ix] = array(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]],/dominant)
		'MEDIAN'   : rrr[ix] = median(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]])
		'COUNT'    : rrr[ix] = n_elements(ri[ri[x[ix]]:ri[x[ix]+1]-1])
		'FRACTION' : rrr[ix] = total(data[ri[ri[x[ix]]:ri[x[ix]+1]-1]] eq n1)/n_elements(ri[ri[x[ix]]:ri[x[ix]+1]-1])
					
	endcase
	
endfor 

if gr1_is_string then gr2 = gr1_temp[long(gr2)]

	; return domain grid

if var_set(domain,minfo,/if_any) then begin

	if ~var_set(missing) then missing = -999.

	gr = aqm_grid(domain=domain,minfo=minfo,ominfo=minfo)
	
	rrr2 = var_set(time) ? make_array(minfo.nx,minfo.ny,time,value=missing): make_array(minfo.nx,minfo.ny,value=missing)	
	xx   = var_set(time) ? where(gr2 ge 0 and gr2 lt minfo.nx*minfo.ny*time,nxx) : where(gr2 ge 0 and gr2 lt minfo.nx*minfo.ny,nxx)
	
	if nxx gt 0 then rrr2[gr2[xx]] = rrr[xx]
	
	rrr = temporary(rrr2)
	
	oindex = where(rrr ne missing)
		
endif 

return,rrr

end
