;-------------------------------------------------------------------------------
;	NAME
;		gif_extract_color
;
;	PURPOSE
;		Extract color(s) from GIF file
;
;	USAGE
;		ii = gif_extract_color(file,color,level[,odim=dim])
;
;	INPUT
;		file  : GIF file
;		color : color names to extract
;		level : allowance level
;
;	OUTPUT
;		odim : return image dimension
;
;	AUTHOR
;		2014-04-09 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function gif_extract_color,file,_color,_level,odim=dim
	
;-------------------------------------------------------------------------------

message,/info,str(/join,'READ',file)
read_gif,file,dd,r,g,b
dim   = size(dd,/dim)
n     = n_elements(_color)
level = array(var_set(_level,ina=5),count=n)
color = color_load(_color,/triple)

	;

for i=0L,n-1 do begin

	s = sort((float(r)-color.r[i])^2+(float(g)-color.g[i])^2+(float(b)-color.b[i])^2)	
	xx1 = reform(idx(idx(dd,s[0:level[i]],/contain),/mask,count=product(dim)),dim,/overwrite)
	if ~var_set(xx) then xx = bytarr([dim,n])
	xx[*,*,i] = xx1

endfor
	
return,xx
end
