;-------------------------------------------------------------------------------	
;	NAME
;		file_time
;
;	PURPOSE
;		ro return elapsed time from ctime (mtime/atime) of file
;
;	USAGE
;		r = file_time(file,tflag)
;
;	INPUT
;		file  : file names
;		tflag : if given, it returns the elapsed time from tflag
;
;	KEYWORD
;		ctime : creation time
;		mtime : modification time
;		atime : access time
;
;	AUTHOR
;		2013-07-23 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------	

	function file_time1,tt,tflag
	
;-------------------------------------------------------------------------------	

for itt=0L,n_elements(tt)-1 do begin

	rr1 = ~var_set(tflag) ? (systime(1)-systime(1,tt[itt]))/86400d $
	      : double(julday(1,1,1970,0,0,0)+systime(1,tt[itt])/86400d)-double(date(tflag,/tflag_to_julday))
	      	      
	rr = var_set(rr) ? [rr,rr1] : [rr1]

endfor

return,rr
end
;-------------------------------------------------------------------------------

	function file_time,file,tflag,ctime=ctime,atime=atime,mtime=mtime,hour=hour
	
;-------------------------------------------------------------------------------

ii = file_info(file)

case 1 of

	keyword_set(ctime) : rr = file_time1(ii.ctime,tflag)
	keyword_set(atime) : rr = file_time1(ii.atime,tflag)
	keyword_set(mtime) : rr = file_time1(ii.mtime,tflag)
	else : rr = file_time1(ii.ctime,tflag)

endcase

case 1 of

	keyword_set(hour) : rr = rr*24d
	keyword_set(min)  : rr = rr*24d*60d
	keyword_set(sec)  : rr = rr*24d*60d*60d	
	else : 

endcase

return,rr
end
