;-------------------------------------------------------------------------------
;	NAME
;		file_renew
;
;	PURPOSE
;		to test if save file needs to be renewed
;
;	USAGE
;		file_renew(file,day1,tflag,day2[,/ctime,/atime,/mtime][,/renew])
;
;	INPUT
;		file   : file to test
;		day1   : no need to renew till "day1" days after last renew
;		tflag/day2 : no need to renew if "day2" days passed after "tflag"
;
;	KEYWORD
;		ctime : check creation time (default)
;		mtime : check modification time
;		atime : check access time
;
;	AUTHOR
;		2013-07-23 Hyun Choel Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function file_renew,_file,dd1,dd2,dd3,ctime=ctime,atime=atime,mtime=mtime,$
	         renew=_renew

;-------------------------------------------------------------------------------

file = _file[0]
if ~file_test(file) then return,1B
if ~var_set(dd1) then dd1 = 1
if ~var_set(dd2) then dd2 = 19700101
if ~var_set(dd3) then dd3 = 5

tt1  = file_time(file,ctime=ctime,atime=atime,mtime=mtime)
tt2  = file_time(file,dd2,ctime=ctime,atime=atime,mtime=mtime) 

if tt2 lt dd3 and tt1 gt dd1 then renew = 1 else renew = 0B
if ~file_test(file) then renew = 1B
if var_set(_renew) then renew = _renew

return,keyword_set(renew)
end
