;-------------------------------------------------------------------------------

	function dn_no2_omi_temis,cday

;-------------------------------------------------------------------------------

if str(cday) lt '20041001' then return,0b

sdir = path_check(getenv('HOME'),'data','temis','omi','no2',cday,/make)
ftp  = 'http://www.temis.nl/airpollution/no2col/data/omi/data_v2/'+date(cday,/cut,/year)+'/'

if dn_complete(sdir,oinfo=dni,renew=[1,long(cday),5]) then return,dni.list

run_scr,'wget -c '+ftp+'omi_no2_he5_'+str(cday)+'.tar',cd=sdir
run_scr,'tar xvf *.tar',cd=sdir
run_scr,'rm -rf *.tar',cd=sdir

file = file_search(sdir,'*.he5',count=nfile)
xxxx = dn_complete(sdir,list=file,/complete)

return,nfile gt 0 ? file : 0B
end
