;-------------------------------------------------------------------------------

	function dn_no2_gome2a_temis,cday,ver
	
;-------------------------------------------------------------------------------

if strlen(str(cday)) ne 8 then message,'[USAGE] rd_no2_gome2_temis(YYYYMMDD)'
if str(cday) lt '20070104'   then return,0b
if str(cday) gt date(/today) then return,0b
if ~var_set(ver) then ver = 'v2'

odir  = path_check(getenv('HOME'),'data','temis','gome2a','no2',ver,'l2','hdf',/make)
ofile = path_check(odir,'no2track'+str(cday)+'.hdf')
finfo = file_info(ofile)

if ~keyword_set(renew) and finfo.size gt 0 and date(cday,date(/today),/count) gt 1 then return,ofile

list = 'wget -c http://www.temis.nl/airpollution/no2col/data/gome2_'+ver+'/'+path_check(date(cday,/cut,/year),date(cday,/cut,/month),'no2track'+str(cday)+'.hdf')+' -O '+ofile
run_scr,list

finfo = file_info(ofile)

return,finfo.size gt 0 ? ofile : 0B
end
