;-------------------------------------------------------------------------------

	function dn_hys_arl,_tflag,_extra=_ex

;-------------------------------------------------------------------------------

if ~struct_set(_ex,'file') then message,'FILE should be specified'

if struct_set(_ex,'format') then begin

	format = _ex.format eq 1 ? '%Y%m%d' : _ex.format 	
	xx     = str_pos(_ex.file,date(date(date(min(_tflag)),date(max(_tflag)),/make),format,/format),/contain)	
	file   = data_check(_ex.file,xx,/index,ina='')
	
	return,file

endif else begin

	return,_ex.file

endelse

end
;-------------------------------------------------------------------------------

	function dn_hys_rean,_tflag

;-------------------------------------------------------------------------------

tflag = date(date(min(_tflag),-1,/incr,/day),date(max(_tflag),1,/incr,/day),/make)
ftp   = 'ftp://arlftp.arlhq.noaa.gov/pub/archives/reanalysis/'
odir  = path_check(getenv('HOME'),'data','hysplit','rean',/make)
file  = path_check(odir,ary(date(tflag,'RP%Y%m.gbl',/format),/uniq))

if total(file_test(file)) ne n_elements(file) then begin

	line = 'wget -c '+ftp+file_basename(file)
	run_scr,line,cd=odir

endif

return,file
end
;-------------------------------------------------------------------------------

	function dn_hys_gdas0p5,_tflag

;-------------------------------------------------------------------------------

tflag = date(date(min(_tflag),-1,/incr,/day),date(max(_tflag),1,/incr,/day),/make)
ftp   = 'ftp://arlftp.arlhq.noaa.gov/pub/archives/gdas0p5/'
odir  = path_check(getenv('HOME'),'data','hysplit','gdas0p5',/make)
file  = path_check(odir,ary(date(tflag,'%Y%m%d_gdas0p5',/format),/uniq))

if total(file_test(file)) ne n_elements(file) then begin

	line = 'wget -c '+ftp+file_basename(file)
	run_scr,line,cd=odir

endif

return,file
end
;-------------------------------------------------------------------------------

	function dn_hys_gdas1,_tflag

;-------------------------------------------------------------------------------

tflag = date(date(min(_tflag),-1,/incr,/day),date(max(_tflag),1,/incr,/day),/make)
ftp   = 'ftp://arlftp.arlhq.noaa.gov/pub/archives/gdas1/'
odir  = path_check(getenv('HOME'),'data','hysplit','gdas1',/make)
file  = path_check(odir,ary(str(/low,date(tflag,'gdas1.%b%y.w',/format))+str((fix(date(tflag,/cut,/day))-1)/7+1),/uniq))

if total(file_test(file)) ne n_elements(file) then begin

	line = 'wget -c '+ftp+file_basename(file)
	run_scr,line,cd=odir

endif

if min(date(date(_tflag),date(/today),/count)) lt 7 then begin

	current = path_check(odir,'current7days')
	
	if file_renew(current,1,date(/today)) then begin
	
		file_delete,current,/allow_nonexistent	
		line = 'wget ftp://ftpprd.ncep.noaa.gov/pub/data/nccf/com/hysplit/prod/gdas/current7days'
		run_scr,line,cd=odir
	
	endif

	file = [current,file]

endif

return,file
end
;-------------------------------------------------------------------------------

	function dn_hysplit_input,tflag,_type,_extra=_ex

;-------------------------------------------------------------------------------

case str(/low,var_set(_type,ina='gdas1')) of

	'gdas1'   : file = dn_hys_gdas1(tflag)
	'gdas0p5' : file = dn_hys_gdas0p5(tflag)
	'rean'    : file = dn_hys_rean(tflag)
	'arl'     : file = dn_hys_arl(tflag,_extra=_ex)
	
endcase

file = data_check(file,file_test(file))
return,file
end
