;-------------------------------------------------------------------------------
;	NAME
;		dn_complete
;
;	PURPOSE
;		to put a note of completion of file downloading
;
;	USAGE
;		dn_complete(sdir[,list=,cday=,refresh=][,/complete][,oinfo=out])
;	
;		if dn_complete(sdir,oinfo=dni,renew=[1,long(cday),5]) then return,dni.list
;		xx = dn_complete(sdir,list=file,/complete)
;
;	INPUT
;		sdir : target directory
;		list : file list
;		renew : renew condition (see file_renew.pro)
;
;	KEYWORD
;		complete : save file list
;
;	OUTPUT
;		oinfo : {test:,list:,missing}
;
;
;	AUTHOR
;		2013-08-19 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function dn_complete,sdir,list=list,renew=renew,complete=complete,oinfo=oi
	
;-------------------------------------------------------------------------------

file = path_check(sdir,'dn_complete')

case 1 of

	keyword_set(complete) : begin
	
		openw,lun,file,/get_lun
		for i=0L,n_elements(list)-1 do printf,lun,list[i]
		free_lun,lun
		return,1B
		end
		
	else : begin
	
		if ~file_test(file) then return,0B				
		if var_set(renew) then if file_renew(file,float(renew[0]),str(renew[1]),float(renew[2])) then return,0B
									
		cc = file_test((list=rd_text(file,oinfo=ii,/trim)))											
		oi = {test:cc,list:data_check(list,cc,ina=0B),missing:data_check(list,~cc,ina=0B)}							
		rr = (total(cc) eq ii.nline) or (n_elements(list) eq 1 and str(list[0]) eq '')
		
		return,rr
		end		
		
endcase

end
