;-------------------------------------------------------------------------------
;	NAME
;		date_check
;
;	PURPOSE
;		to exam date input is in proper form
;
;	USAGE
;		data_check,tflag[,/monthly,/daily,/hourly]
;
;	INPUT
;		tflag : YYYYMMDDHH, YYYYMMDD, YYYYMM
;
;	AUTHOR
;		2015-04-23 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2015-12-04 modified
;-------------------------------------------------------------------------------

	pro date_check,dd1,monthly=monthly,daily=daily,hourly=hourly,olen=mx

;-------------------------------------------------------------------------------

if ~var_set(dd1) then message,'### USAGE CHECK ### TIMEFLAG missing',level=-1,/continue
if min(strlen(str(dd1)),max=mx) ne mx then message,'### USAGE CHECK ### TIMEFLAG inconsistent',level=-1

case 1 of

	keyword_set(hourly)  : if mx ne 10 then message,'### USAGE CHECK ### TFLAG = "YYYYMMDDHH"',level=-1
	keyword_set(daily)   : if mx ne 8  then message,'### USAGE CHECK ### TFLAG = "YYYYMMDD"',level=-1
	keyword_set(monthly) : if mx ne 6  then message,'### USAGE CHECK ### TFLAG = "YYYYMM"',level=-1
	else : 

endcase

end
