;-------------------------------------------------------------------------------
;	NAME
;		DATA_INFO_MISSING
;
;	PURPOSE
;		guess missing value from data array
;
;	USAGE
;		mm = data_info_missing(data)
;
;	INPUT
;		data : data array
;
;	RETURN
;		mm.missing : missing value			
;
;	NOTE
;		just quick and dirty method to find missing vlaue.
;		Should not be really trusted.
;
;	AUTHOR
;		2011-09-22 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function data_info_missing,_data,missing=missing
	
;-------------------------------------------------------------------------------

	; check NAN
xx = finite(_data)
if total(xx) eq 0 then return,0B else data = _data[where(xx)]

	; if value is uniq, return 0B

min0 = min(data,max=max0)

if min0 eq max0 then return,0B

	; check bottom half

if ~var_set(missing) then begin

	xx = where(data lt (min0+max0)/2.,nxx)
	if nxx eq 0 then return,0B
	min2 = min(data[xx],max=max2)
	if min2 eq max2 then missing = min2
	
endif	

	; check top half

if ~var_set(missing) then begin

	xx = where(data gt (min0+max0)/2.,nxx)
	if nxx eq 0 then return,0B
	min2 = min(data[xx],max=max2)
	if min2 eq max2 then missing = min2

endif

if var_set(missing) then return,{missing:missing} else return, 0B

end
