;-------------------------------------------------------------------------------
;	NAME
;		data_check
;
;	PURPOSE
;		simple wrapper for where function
;
;	USAGE
;		rr = data_check(rr,test[,dim=][,/
;
;	INPUT
;		data : data array
;		test : test condition to get where
;		d1   : value to replace
;		dim  : specify dimension 
;		if_not_available/ina : if test fails return "ina"
;
;	KEYWORD
;		
;		index : test is already index
;		range : use [min:max] range instead of individual indices
;		rewrite : do not keep original data
;
;	OUTPUT
;		oxx : return indices used
;
;	AUTHOR
;		2012-01-05 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2012-10-22 added var_set(dim)
;-------------------------------------------------------------------------------

	function data_check,_data,test,d1,dim=dim,range=range,index=index,$
	         if_not_available=ina,ina=_ina,rewrite=rewrite,oxx=xx
	
;-------------------------------------------------------------------------------

if ~var_set(_data) then return,!null
data = keyword_set(rewrite) ? temporary(_data) : _data
if var_set(_ina) then ina = _ina

	; get condition or index
	
if keyword_set(index) then if n_elements((xx=test)) eq 1 and test[0] eq -1 then nxx = 0L else nxx = n_elements(xx) else xx = where(test,nxx)

	; 

case 1 of

	keyword_set(range) : if nxx gt 0 then data = data[min(xx):max(xx)] else if var_set(ina) then data = ina
				
	var_set(d1,dim) : begin
	
		case dim of
		
			1 : if nxx gt 0 then data[xx,*,*,*,*,*,*,*] = d1 else if var_set(ina) then data = ina
			2 : if nxx gt 0 then data[*,xx,*,*,*,*,*,*] = d1 else if var_set(ina) then data = ina
			3 : if nxx gt 0 then data[*,*,xx,*,*,*,*,*] = d1 else if var_set(ina) then data = ina 
			4 : if nxx gt 0 then data[*,*,*,xx,*,*,*,*] = d1 else if var_set(ina) then data = ina
			5 : if nxx gt 0 then data[*,*,*,*,xx,*,*,*] = d1 else if var_set(ina) then data = ina 
			6 : if nxx gt 0 then data[*,*,*,*,*,xx,*,*] = d1 else if var_set(ina) then data = ina
			7 : if nxx gt 0 then data[*,*,*,*,*,*,xx,*] = d1 else if var_set(ina) then data = ina 
			8 : if nxx gt 0 then data[*,*,*,*,*,*,*,xx] = d1 else if var_set(ina) then data = ina
													
		endcase
				
		end
		
	var_set(dim) : begin
		
		case dim of
		
			1 : if nxx gt 0 then data = data[xx,*,*,*,*,*,*,*] else if var_set(ina) then data = ina 
			2 : if nxx gt 0 then data = data[*,xx,*,*,*,*,*,*] else if var_set(ina) then data = ina 
			3 : if nxx gt 0 then data = data[*,*,xx,*,*,*,*,*] else if var_set(ina) then data = ina
			4 : if nxx gt 0 then data = data[*,*,*,xx,*,*,*,*] else if var_set(ina) then data = ina 
			5 : if nxx gt 0 then data = data[*,*,*,*,xx,*,*,*] else if var_set(ina) then data = ina 
			6 : if nxx gt 0 then data = data[*,*,*,*,*,xx,*,*] else if var_set(ina) then data = ina 
			7 : if nxx gt 0 then data = data[*,*,*,*,*,*,xx,*] else if var_set(ina) then data = ina 
			8 : if nxx gt 0 then data = data[*,*,*,*,*,*,*,xx] else if var_set(ina) then data = ina 
											
		endcase
		
		end	
	
	var_set(d1) : if nxx gt 0 then data[xx] = n_elements(data) eq n_elements(d1) ? d1[xx] : d1 
				
	else : if nxx gt 0 then data = data[xx] else if var_set(ina) then data = ina

endcase

return,data
end

