;-------------------------------------------------------------------------------
;	NAME
;		cvdat
;
;	PURPOSE	
;		to convert values
;
;	USAGE
;		ws = cvdat(u,v,/wind_speed,owd=owd)
;		u  = cvdat(ws,wd,/uwind,ovwind=v)
;
;	INPUT
;		
;
;	KEYWORD
;		wind_speed : convert u/v to wind speed/direction
;		uwind      : convert ws/wd to u/v wind
;
;
;
;	AUTHOR
;		2010-01-08 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function cvdat,d1,d2,d3,$
	         wind_speed=wind_speed,owd=owd,ows=ows,$
	         uwind=uwind,ouwind=ouwind,ovwind=ovwind
		 
;-------------------------------------------------------------------------------		 

if ~var_set(missing) then missing = -999.

case 1 of

	keyword_set(wind_speed) : begin
	
		x = where(d1 eq missing or d2 eq missing,nx)
		
		ows = sqrt(d1^2+d2^2)
		owd = ((d2 ge 0)*((90.-acos(d1/ows)/!dtor)+360.*(d1 lt 0))+(d2 lt 0)*((90.-asin(d2/ows)/!dtor)*(-1.+2.*(d1 ge 0))+360.*(d1 lt 0)) + 180) mod 360
		
		if nx gt 0 then ows[x] = missing
		if nx gt 0 then owd[x] = missing
		
		return,ows
		
		end
		
	keyword_set(uwind) : begin
	
		x = where(d1 eq missing or d2 eq missing,nx)
		
		ouwind = d1*cos((270.-d2)*!dtor)
		ovwind = d1*sin((270.-d2)*!dtor)
		
		if nx gt 0 then ouwind[x] = missing
		if nx gt 0 then ovwind[x] = missing
		
		return,ouwind
		
		end		

endcase

end
