;-------------------------------------------------------------------------------

	function cv_wind,_d1,_d2,missing=missing,$
	         component_to_direction,direction_to_component=direction_to_component,$
	         ows=ows,owd=owd,ouwind=ouwind,ovwind=ovwind
			
;-------------------------------------------------------------------------------

d1 = aqm_array(_d1,/nan,missing=missing)
d2 = aqm_array(_d2,/nan,missing=missing)

case 1 of

	keyword_set(component_to_direction) : begin
	
		ows = sqrt(d1^2+d2^2)
		owd = ((d2 ge 0)*((90.-acos(d1/ows)/!dtor)+360.*(d1 lt 0))+(d2 lt 0)*((90.-asin(d2/ows)/!dtor)*(-1.+2.*(d1 ge 0))+360.*(d1 lt 0)) + 180) mod 360
		return,ows	
		end
		
	keyword_set(direction_to_component) : begin
	
		ouwind = d1*cos((270.-d2)*!dtor)
		ovwind = d1*sin((270.-d2)*!dtor)
		return,ouwind
		end		

endcase

end
