;-------------------------------------------------------------------------------
;
;	color_table3
;	color_table2
;	color_table	
;
;-------------------------------------------------------------------------------
;	NAME
;		color_table3
;
;	PURPOSE
;		load color table for 'difference' plot using Brewer colors
;
;	USAGE
;		ct = color_table3(color=color,range=[],/interp)
;
;	INPUT
;		color : color names to load (default is Brewer colors)
;		range : range of color index (0~255)
;		option : 
;	
;	KEYWORD
;		interp : interpolate colors	
;
;	AUTHOR
;		2010-05-13 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function color_table3,color=color,range=range,interp=interp,option=_opt
	
;-------------------------------------------------------------------------------

COMPILE_OPT IDL2

opt = {range:[40,!d.table_size-1],color_set:1,interp:0}

if var_set(range)  then opt = struct(/merge,opt,{range:range})
if var_set(interp) then opt = struct(/merge,opt,{interp:interp})
if struct(/set,_opt) then opt = struct(/merge,opt,_opt)

	; set color
	
if struct(/set,opt,'color') then begin

	

endif else begin	

case opt.color_set of

	1   : opt = struct(/merge,opt,{color:['RYB'+str(-indgen(4)+8),'white','RYB'+str(-indgen(4)+4)]})
	2   : opt = struct(/merge,opt,{color:['BLU'+str(-indgen(8)+8),'white','RED'+str(indgen(8)+1)]})
	3   : opt = struct(/merge,opt,{color:['GRN'+str(-indgen(8)+8),'white','RED'+str(indgen(8)+1)]})
	4   : opt = struct(/merge,opt,{color:['PUR'+str(-indgen(8)+8),'white','TAN'+str(indgen(8)+1)]})
	5   : opt = struct(/merge,opt,{color:['BLU'+str(-indgen(8)+8),'white','ORG'+str(indgen(8)+1)]})
	6   : opt = struct(/merge,opt,{color:['PBG'+str(-indgen(8)+8),'white','ORG'+str(indgen(8)+1)]})
	
	101 : opt = struct(/merge,opt,{color:['RYB'+str(-indgen(4)+8),'RYB'+str(-indgen(4)+4)]})
	102 : opt = struct(/merge,opt,{color:['BLU'+str(-indgen(8)+8),'RED'+str(indgen(8)+1)]})
	103 : opt = struct(/merge,opt,{color:['GRN'+str(-indgen(8)+8),'RED'+str(indgen(8)+1)]})
	104 : opt = struct(/merge,opt,{color:['PUR'+str(-indgen(8)+8),'TAN'+str(indgen(8)+1)]})
	105 : opt = struct(/merge,opt,{color:['BLU'+str(-indgen(8)+8),'ORG'+str(indgen(8)+1)]})
	106 : opt = struct(/merge,opt,{color:['PBG'+str(-indgen(8)+8),'ORG'+str(indgen(8)+1)]})
	
	else : 
		
endcase	

endelse



	; update color

triple = color_load(opt.color,/triple)

tvlct,ctr,ctg,ctb,/get

r = congrid(triple.r,opt.range[1]-opt.range[0]+1,interp=opt.interp,/center)
g = congrid(triple.g,opt.range[1]-opt.range[0]+1,interp=opt.interp,/center)
b = congrid(triple.b,opt.range[1]-opt.range[0]+1,interp=opt.interp,/center)

ctr[opt.range[0]:opt.range[1]] = r
ctg[opt.range[0]:opt.range[1]] = g
ctb[opt.range[0]:opt.range[1]] = b

tvlct,ctr,ctg,ctb
	
	; div
	
ndiv1 = n_elements(opt.color)
div1  = keyword_set(opt.interp) ? findgen(ndiv1+1)/ndiv1*(opt.range[1]-opt.range[0])+opt.range[0] $
      : [where((r-shift(r,1) ne 0)+ (g-shift(g,1) ne 0)+(b-shift(b,1) ne 0) ne 0)+opt.range[0],opt.range[1]+1]

	; return
 
result = {range:opt.range,div1:div1,ndiv1:n_elements(div1),div:div1,ndiv:n_elements(div1),type:3}

return,result

end


;------------------------------------------------------------------------------- 
;	NAME
;		color_table
;
;	PURPOSE
;		IDL function to build color talbe
;
;	USAGE
;		ct = color_table(option=option[,/colorbar])
;
;	INPUT
;		missing : missing value (-1)
;		range   : color index range (40,255)
;		ndiv1   : major divisions
;		ndiv2   : minor divisions
;		color   : colors to use
;		scolor  : starting color
;		ecolor  : ending color
;
;	KEYWORD
;		colorbar : show colorbar
;		show     : show colorbar
;
;	AUTHRO
;		2007-11-09 Hyun Cheol Kim (hyuncheol.kim@gmail.com, hkim2@mail.uh.edu)
;
;------------------------------------------------------------------------------- 

	function color_table2,file=file,$
	         missing=_missing,range=range,ndiv1=ndiv1,ndiv2=ndiv2,color=color,$
	         scolor=scolor,ecolor=ecolor,sstep=sstep,estep=estep,even=even,$
	         option=option,show=show,zdiv1=zdiv1,zdepth=zdepth
 
;------------------------------------------------------------------------------- 

COMPILE_OPT IDL2

opt = {missing:-1,range:[40,!d.table_size-1],ecolor:'Black',estep:0.7,even:1}

if var_set(missing) then opt = struct(/merge,opt,{missing:missing})
if var_set(range)   then opt = struct(/merge,opt,{range:range})
if var_set(color)   then opt = struct(/merge,opt,{color:color})
if var_set(ndiv1)   then opt = struct(/merge,opt,{ndiv1:ndiv1})
if var_set(ndiv2)   then opt = struct(/merge,opt,{ndiv2:ndiv2})
if var_set(scolor)  then opt = struct(/merge,opt,{scolor:scolor})
if var_set(ecolor)  then opt = struct(/merge,opt,{ecolor:ecolor})
if var_set(sstep)   then opt = struct(/merge,opt,{sstep:sstep})
if var_set(estep)   then opt = struct(/merge,opt,{estep:estep})
if var_set(even)    then opt = struct(/merge,opt,{even:even})
if var_set(zdiv1)   then opt = struct(/merge,opt,{zdiv1:zdiv1})
if var_set(zdepth)  then opt = struct(/merge,opt,{zdepth:zdepth})
if var_set(file)    then opt = struct(/merge,opt,{file:file})

if struct(/set,option) then opt = struct(/merge,opt,option)

	; 

if struct(/set,opt,'file') then begin

	if file_test(opt.file) then begin
		
		ct = struct(opt.file,/file)

		ndiv  = n_elements(ct.d)		
		div   = round(findgen(ndiv)/(ndiv-1)*(opt.range[1]-opt.range[0])+opt.range[0])
		
		jdiv1 = where(ct.d eq 1,njdiv1)
		jdiv2 = where(ct.d eq 0,njdiv2)
		
		if njdiv1 gt 0 then div1 = div[jdiv1]
		if njdiv2 gt 0 then div2 = div[jdiv2]
		
		ndiv1 = njdiv1
		ndiv2 = njdiv2
				
		range2 = opt.range+[0,1]

		r = make_array(range2[1]+1,/integer,value=opt.missing)
		g = make_array(range2[1]+1,/integer,value=opt.missing)
		b = make_array(range2[1]+1,/integer,value=opt.missing)
				
		if ndiv1 gt 0 then r[div] = ct.r
		if ndiv1 gt 0 then g[div] = ct.g
		if ndiv1 gt 0 then b[div] = ct.b
	
	endif else begin
	
		message,str(/join,'[NOFILE]',opt.file)
	
	endelse

endif else begin

		; ndiv1, ndiv2 & color

	case 4*struct(/set,opt,'color')+2*struct(/set,opt,'ndiv1')+struct(/set,opt,'ndiv2') of

		0 : begin 
	
			color = ['Lime Green','Yellow','Orange','Fire Brick','Purple','Maroon']
			ndiv1 = n_elements(color)
			ndiv2 = array(4,count=ndiv1)
			end
		
		1 : begin
	
			color = ['Lime Green','Yellow','Orange','Fire Brick','Purple','Maroon']
			ndiv1 = n_elements(color)	
	
			if n_elements(opt.ndiv2) eq 1 then begin
		
				ndiv2 = array(opt.ndiv2,count=ndiv1)			
				
			endif else begin
		
				ndiv2 = opt.ndiv2
				ndiv1 = n_elements(ndiv2)
				color = array(color,count=ndiv1)
				
			endelse	
			end
		
		2 : begin
	
			ndiv1 = opt.ndiv1
			color = array(['Lime Green','Yellow','Orange','Fire Brick','Purple','Maroon'],count=ndiv1)
			ndiv2 = array(4,count=ndiv1)		
			end	
		
		3 : begin
	
			ndiv1 = opt.ndiv1
			color = array(['Lime Green','Yellow','Orange','Fire Brick','Purple','Maroon'],count=ndiv1)		
			ndiv2 = array(opt.ndiv2,count=ndiv1)	
			end	
		
		4 : begin
	
			color = opt.color
			ndiv1 = n_elements(color)
			ndiv2 = array(4,count=ndiv1)
			end
		
		5 : begin
	
			color = opt.color
			ndiv1 = n_elements(color)
			ndiv2 = array(opt.ndiv2,count=ndiv1)
			end
		
		6 : begin
	
			ndiv1 = opt.ndiv1
			color = array(opt.color,count=ndiv1)
			ndiv2 = array(4,count=ndiv1)
			end
		
		7 : begin
	
			if n_elements(opt.ndiv2) eq 1 then begin
		
				ndiv1 = opt.ndiv1
				ndiv2 = array(opt.ndiv2,count=ndiv1)
				color = array(opt.color,count=ndiv1)

			endif else begin
		
				ndiv2 = opt.ndiv2
				ndiv1 = n_elements(ndiv2)
				color = array(opt.color,count=ndiv1)
		
			endelse
			end
								
	endcase

			; misc setting

	color2 = [color,opt.ecolor]
	range2 = opt.range+[0,1]
	estep  = array(opt.estep,count=ndiv1)

	if ~struct(/set,opt,'sstep') then begin
	
		sstep = replicate(0.,ndiv1)
		x = where(ndiv2 gt 1,nx)
		if nx gt 0 then sstep[x] = estep[x]/(ndiv2[x]-1) 

	endif	else sstep = opt.sstep

	sstep = array(sstep,count=ndiv1)

		; set array

	r = make_array(range2[1]+1,/integer,value=opt.missing)
	g = make_array(range2[1]+1,/integer,value=opt.missing)
	b = make_array(range2[1]+1,/integer,value=opt.missing)	
										 
	triple = color_load(color2,/triple)	

	  ; set div1

	div1 = keyword_set(opt.even) ? $
	       (round(findgen(total(ndiv2)+1)*(range2[1]-range2[0])/total(ndiv2)+range2[0]))[[0,total(ndiv2,/cumulative)]] : $
				 round(findgen(ndiv1+1)*(range2[1]-range2[0])/ndiv1+range2[0])
		 				 			 			 
	r[div1] = triple.r
	g[div1] = triple.g
	b[div1] = triple.b

		; set div2

	for idiv1=0L,ndiv1-1 do begin

	  if ndiv2[idiv1] ge 2 then begin
	
		  div2i = (round(findgen(ndiv2[idiv1]+1)*(div1[idiv1+1]-div1[idiv1])/ndiv2[idiv1]+div1[idiv1]))[1:ndiv2[idiv1]-1]
		  
	    if not var_set(div2) then div2 = div2i else div2 = [div2,div2i]	
		
			if ndiv2[idiv1] ge 3 then begin
				
				r[div2i] = ((sstep[idiv1]-estep[idiv1])*triple.r[idiv1]+(estep[idiv1]-sstep[idiv1])*triple.r[idiv1+1])*$
				           findgen(ndiv2[idiv1]-1)/(ndiv2[idiv1]-2)+((1.-sstep[idiv1])*triple.r[idiv1]+sstep[idiv1]*triple.r[idiv1+1])
				g[div2i] = ((sstep[idiv1]-estep[idiv1])*triple.g[idiv1]+(estep[idiv1]-sstep[idiv1])*triple.g[idiv1+1])*$
				           findgen(ndiv2[idiv1]-1)/(ndiv2[idiv1]-2)+((1.-sstep[idiv1])*triple.g[idiv1]+sstep[idiv1]*triple.g[idiv1+1])
				b[div2i] = ((sstep[idiv1]-estep[idiv1])*triple.b[idiv1]+(estep[idiv1]-sstep[idiv1])*triple.b[idiv1+1])*$
				           findgen(ndiv2[idiv1]-1)/(ndiv2[idiv1]-2)+((1.-sstep[idiv1])*triple.b[idiv1]+sstep[idiv1]*triple.b[idiv1+1])
									
			endif else begin
											
	    	r[div2i] = (((1.-estep[idiv1])*triple.r[idiv1]+estep[idiv1]*triple.r[idiv1+1]-triple.r[idiv1])*findgen(ndiv2[idiv1])/(ndiv2[idiv1]-1)+triple.r[idiv1])[1:*]								
				g[div2i] = (((1.-estep[idiv1])*triple.g[idiv1]+estep[idiv1]*triple.g[idiv1+1]-triple.g[idiv1])*findgen(ndiv2[idiv1])/(ndiv2[idiv1]-1)+triple.g[idiv1])[1:*]								
		  	b[div2i] = (((1.-estep[idiv1])*triple.b[idiv1]+estep[idiv1]*triple.b[idiv1+1]-triple.b[idiv1])*findgen(ndiv2[idiv1])/(ndiv2[idiv1]-1)+triple.b[idiv1])[1:*]								
			
			endelse	
				
		endif

	endfor

	  ; set starting color

	if struct(/set,opt,'scolor') then begin

	  striple = color_load([opt.scolor,color2[[0,1]]],/triple)
	
		case ndiv2[0] of
	
		  0 : message,'SET ndiv2 > 0'
			1 : 		
		
			else : begin
		
			  n1 = fix((ndiv2[0]-1)/2)
				n2 = ndiv2[0]-n1
			
			  r[div1[0]]        = striple.r[0]
			  g[div1[0]]        = striple.g[0]
			  b[div1[0]]        = striple.b[0]								
			  r[div2[0>(n1-1)]] = striple.r[1]
			  g[div2[0>(n1-1)]] = striple.g[1]
			  b[div2[0>(n1-1)]] = striple.b[1]		
						
				if n1 ge 2 then begin
			
				  r[div2[0:n1-2]] = ((striple.r[1]-striple.r[0])*findgen(n1+1)/n1+striple.r[0])[1:n1-1]
					g[div2[0:n1-2]] = ((striple.g[1]-striple.g[0])*findgen(n1+1)/n1+striple.g[0])[1:n1-1]
					b[div2[0:n1-2]] = ((striple.b[1]-striple.b[0])*findgen(n1+1)/n1+striple.b[0])[1:n1-1]
				
	      endif
			
				if n2 ge 3 then begin
			
				  r[div2[n1:ndiv2[0]-2]] = ((striple.r[2]-striple.r[1])*findgen(n2+1)/n2+striple.r[1])[1:n2-1]
					g[div2[n1:ndiv2[0]-2]] = ((striple.g[2]-striple.g[1])*findgen(n2+1)/n2+striple.g[1])[1:n2-1]
					b[div2[n1:ndiv2[0]-2]] = ((striple.b[2]-striple.b[1])*findgen(n2+1)/n2+striple.b[1])[1:n2-1]
					
				endif

			end
	
		endcase
	
	end

endelse ; ct

  ; fill missing
	
if struct(/set,opt,'zdiv1') then begin

	 for i=range2[0]+1,div1[opt.zdiv1] do begin
	 
		if r[i] eq opt.missing then r[i] = r[i-1]
		if g[i] eq opt.missing then g[i] = g[i-1]
		if b[i] eq opt.missing then b[i] = b[i-1]	 
	 	 
	 endfor
	 
	 for i=range2[1]-1,div1[opt.zdiv1],-1 do begin
	 
		if r[i] eq opt.missing then r[i] = r[i+1]
		if g[i] eq opt.missing then g[i] = g[i+1]
		if b[i] eq opt.missing then b[i] = b[i+1]	 
	 
	 endfor
	 	 
	 if struct(/set,opt,'zdepth') then begin
	 
	 	i = div1[opt.zdiv1]
		
		r[(i-opt.zdepth)>range2[0]:(i+opt.zdepth)<range2[1]] = r[i]
		g[(i-opt.zdepth)>range2[0]:(i+opt.zdepth)<range2[1]] = g[i]
		b[(i-opt.zdepth)>range2[0]:(i+opt.zdepth)<range2[1]] = b[i]
	 
	 endif

endif else begin

	for i=range2[0]+1,range2[1]-1 do begin

		if r[i] eq opt.missing then r[i] = r[i-1]
		if g[i] eq opt.missing then g[i] = g[i-1]
		if b[i] eq opt.missing then b[i] = b[i-1]

	endfor
	
endelse	

  ; load and replace color table

tvlct,ctr,ctg,ctb,/get

ctr[range2[0]:range2[1]-1] = r[range2[0]:range2[1]-1]
ctg[range2[0]:range2[1]-1] = g[range2[0]:range2[1]-1]
ctb[range2[0]:range2[1]-1] = b[range2[0]:range2[1]-1]

tvlct,ctr,ctg,ctb

	; loadct

if struct(/set,opt,'loadct') then loadct,opt.loadct,bottom=opt.range[0]

  ; set result

if var_set(div2) then begin

		; remove 256

	div1  = [div1[0:n_elements(div1)-2],div1[n_elements(div1)-1]-1]
	div   = array([div1,div2],/uniq)
	;range = range-[0,1]

	result = {div1:div1,ndiv1:ndiv1,div2:div2,ndiv2:ndiv2,div:div,ndiv:n_elements(div)-1,range:opt.range,type:2}	
	
endif else begin

	result = {div1:div1,ndiv1:ndiv1,div:div1,ndiv:ndiv1,range:opt.range-[0,1],type:2}
	
endelse	

  ; return
	
return,result

end

;-------------------------------------------------------------------------------

	function color_table,diff=diff,aqi=aqi,lct=lct,option=opt,_extra=_ex

;-------------------------------------------------------------------------------

COMPILE_OPT IDL2

case 1 of

;	keyword_set(lct)                      : return,color_table1(option=opt,_extra=_ex)
	keyword_set(diff)                     : return,color_table3(option=opt,_extra=_ex)
	keyword_set(struct(/read,opt,'diff')) : return,color_table3(option=opt,_extra=_ex)	
	else                                  : return,color_table2(option=opt,_extra=_ex)

endcase

end
