;-------------------------------------------------------------------------------
;	NAME
;		color_index2 
;
;	PURPOSE
;		IDL function to return color index for color_bar
; 
;	USAGE
;		ct = color_table2()
;		ci = color_index2(data[,range=range][,ct=ct|div1=div1,div2=div2])
;   
;	INPUT
;		data   : data 
;		ct     : output from color_table
;		range  : data range
;		div1   : major divisions
;		div2   : minor divisions
;		option : additional option
;
;	KEYWORD
;		group  : generate group index. see "aqm_plot_tile"
;
;	AUTHOR
;		2007-11-15 Hyun Cheol Kim 
;		2007-12-06 /OPTION ADDED;			   
;		2008-07-28 rewritten to ver 2
;		2008-08-14 div1/div2 improved
;-------------------------------------------------------------------------------

	function color_index2,data,ct=ct,range=range,div1=div1,div2=div2,    $
	         group=group,file=file,raw=raw,missing=missing,mcolor=mcolor,$
	         outside=outside,option=option
 
;-------------------------------------------------------------------------------

COMPILE_OPT IDL2

dim        = size(data,/dim)
data_min   = min(data,max=data_max)
data_range = data_max - data_min

if struct(/set,option,'range')   then range = option.range
if struct(/set,option,'file')    then file  = option.file
if struct(/set,option,'div')     then div   = option.div
if struct(/set,option,'div1')    then div1  = option.div1
if struct(/set,option,'div2')    then div2  = option.div2
if struct(/set,option,'missing') then missing = option.missing

	; from option
	
case 1 of

	var_set(div,div1,div2) :
	var_set(div,div1)      :
	var_set(div,div2)      : message,str(/join,'[USAGE] ci = color_index2(div=div|div1=div1,div2=div2)')
	var_set(div1,div2)     : div = array([div1,div2],/uniq)
	var_set(div)           :
	var_set(div1)          : div = div1
	var_set(div2)          : message,str(/join,'[USAGE] ci = color_index2(div=div|div1=div1,div2=div2)')
	else : 

endcase	

	; from color_table

if struct(/set,ct) then begin
		
	ndiv = ct.ndiv+1

	if not var_set(range) then if data_min eq data_max then range = [data_min-1,data_max+1] else range = [data_min-0.05*data_range,data_max+0.05*data_range]

	if not var_set(div)  then div  = findgen(ndiv)/(ndiv-1)*(range[1]-range[0])+range[0]
	if not var_set(div1) then div1 = div[index(ct.div,ct.div1,/contain)]
	if not var_set(div2) then if struct(/set,ct,'div2') then div2 = div[index(ct.div,ct.div2,/contain)]     
		
	ct_div   = ct.div
	ct_div1  = ct.div1
	ct_range = ct.range

endif

	; from file
		
if var_set(file) then begin
	
	if file_test(file[0]) then begin

		file = struct(/file,file[0])
	
		div  = float(file.i)
		div1 = float(file.i[where(file.d eq 1)])
		div2 = float(file.i[where(file.d ne 1)])
		ndiv = n_elements(div)
					
	endif else message,str(/join,'[NO FILE]',file)				
	
endif

	; get index

if not var_set(ndiv)     then ndiv = n_elements(div)
if not var_set(ct_range) then ct_range = [40,255]
if not var_set(ct_div)   then ct_div = round(findgen(ndiv)/(ndiv-1)*(ct_range[1]-ct_range[0])+ct_range[0])
if not var_set(ct_div1)  then ct_div1 = ct_div[index(div,div1,/contain)]

if keyword_set(raw) then begin

	ci = interpol(ct_div,div,data)

endif else begin
	
	ci = min(ct_div) > interpol(ct_div,div,data) < max(ct_div)
	
	if var_set(missing) then begin
	
		if var_set(missing,/keyword_only) then missing = -999.
		if var_set(mcolor) then mi = color_load(/get,mcolor) else mi = color_load(/get,'white')
		
		xm = where(data eq missing,nm)
		
		if nm gt 0 then ci[xm] = mi
	
	endif
	
	if var_set(outside) then begin
	
		if var_set(outside,/keyowrd_only) then outside = [color_load(/get,'white'),color_load(/get,'black')] 
		
		xo0 = where(ci lt ct_range[0],no0)
		xo1 = where(ct gt ct_range[1],no1)
		
		if no0 gt 0 then ci[xo0] = outside[0]
		if no1 gt 0 then ci[xo1] = outside[1]
			
	endif

end

	; result

result = {index:reform(ci,dim),div:div,div1:div1}

if var_set(div2)  then result = struct(/merge,result,{div2:div2})

	; check group id

if keyword_set(group) then begin

	if n_elements(dim) ne 2  then message,'2D DATA NEEDED FOR /GROUP'

	gr = fix(interpol(indgen(n_elements(div1)),ct_div1,ci))+1
	gi = fix(gr ne array(gr,shift=[1,0]))+2*fix(gr ne array(gr,shift=[0,1]))

	result = struct(/merge,result,{gi:gi})

endif

return,result

end








