;
; Created by Fantine (Mar 2010)
;-------------------------------------------------------------------------------

       function cal_sigma,sigma,pressure=_pressure,height=_height,mid=_mid,   $
                ps=ps,zs=zs,ts=ts,pt=pt

;-------------------------------------------------------------------------------

Rd = 287.05307
gg = 9.80665
LR = -6.5

if ~var_set(ps) then ps = 1013.25
if ~var_set(zs) then zs = 0.
if ~var_set(ts) then ts = 288.15
if ~var_set(pt) then pt = 50.

if keyword_set(_mid) then begin
  aa    = sigma-((sigma-shift(sigma,1))/2.)
  sigma = aa[1:n_elements(aa)-1]
endif

pp   = (sigma*(ps-pt))+pt

tmpB = (pp/ps)^((Rd*(-1.)*LR)/(1000.*gg))
tmpA = ts/LR
zz   = (zs-tmpA*(1-tmpB))*1000.

case 1 of

var_set(_pressure)      : return,pp

var_set(_height)        : return,zz

endcase

end 
