;-------------------------------------------------------------------------------
;	NAME
;		arys
;
;	PURPOSE
;		to perform array operation
;
;	USAGE
;		
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;	INPUT
;		dd : data with multi dimension
;		n1 : dimensison (n1=1,2,3,...) or tflag or nmove
;		n2 : percentile or lon
;		n3 : local time
;
;	AUTHOR
;		2014-12-10 Hyun Cheol Kim (hyun.kim@noaa.gov) rewritten from aryn.pro
;		2014-12-31 restructured options
;-------------------------------------------------------------------------------

	function arys,_dd,n1,n2,n3,count=count,otflag=ot,oidx=oidx,_extra=_ex

;-------------------------------------------------------------------------------

nan  = typename(_dd) eq 'DOUBLE' ? !values.d_nan : !values.f_nan
ndim = n_elements((dim=size(_dd,/dim)))
dd   = data_check(_dd,~finite(_dd) or _dd eq (missing=struct_read(_ex,'missing',-999.)),nan)

case 1 of

	struct_set(_ex,'daily') : begin
		
		if  var_set(n2) then if min(strlen(str(n2)),max=_mx) eq 8 and _mx eq 8 then dy2 = n2 else if min(n2,max=_mx) ge 0 and _mx le 47 then hh = n2
		if  var_set(n3) then if min(strlen(str(n3)),max=_mx) eq 8 and _mx eq 8 then dy2 = n3 else if min(n3,max=_mx) ge 0 and _mx le 47 then hh = n3
								
		dd = struct_set(_ex,'robust') ? arys(dd,n1,hh,/reform_hourly_robust,otflag=dy1) : arys(dd,n1,hh,/reform_hourly,otflag=dy1)						
		ot = (dy2=var_set(dy2,ina=dy1))
		cc = var_set(count,ina=(var_set(hh) ? n_elements(hh) : 24))
						
		case 1 of
		
			struct_set(_ex,'total')  : dd = arys(dd,2,/total,count=cc)
			struct_set(_ex,'min')    : dd = arys(dd,2,/min,count=cc)
			struct_set(_ex,'max')    : dd = arys(dd,2,/max,count=cc)
			struct_set(_ex,'stddev') : dd = arys(dd,2,/stddev,count=cc)			
			else                     : dd = arys(dd,2,/mean,count=cc)
					
		endcase
										
		dd = data_check(dd[*,(xx=idx(dy1,dy2,/point))],xx eq -1,nan,dim=2)		
		return,temporary(ndim gt 2 ? reform(dd,[dim[0:ndim-2],n_elements(ot)],/overwrite) : dd)			
		end
		
	struct_set(_ex,'monthly') : begin
			
		if  var_set(n2) then if min(strlen(str(n2)),max=_mx) eq 6 and _mx eq 6 then mn2 = n2 else message,'USE TFLAG=YYYYMM'

		dd = arys(dd,n1,/reform_monthly,otflag=mn1)
		ot = (mn2=var_set(mn2,ina=mn1))
		
		case 1 of
		
			struct_set(_ex,'total')  : dd = arys(dd,2,/total,count=count)
			struct_set(_ex,'min')    : dd = arys(dd,2,/min,count=count)
			struct_set(_ex,'max')    : dd = arys(dd,2,/max,count=count)
			struct_set(_ex,'stddev') : dd = arys(dd,2,/stddev,count=count)			
			else                     : dd = arys(dd,2,/mean,count=count)
		
		endcase
						
		dd = data_check(dd[*,(xx=idx(mn1,mn2,/point))],xx eq -1,nan,dim=2)				
		return,temporary(ndim gt 2 ? reform(dd,[dim[0:ndim-1],7],/overwrite) : dd)				
		end
		
	struct_set(_ex,'weekly') : begin
				
		dd = arys(dd,n1,/reform_weekly)
		
		case 1 of
		
			struct_set(_ex,'total')  : dd = arys(dd,3,/total,count=count)
			struct_set(_ex,'min')    : dd = arys(dd,3,/min,count=count)
			struct_set(_ex,'max')    : dd = arys(dd,3,/max,count=count)
			struct_set(_ex,'stddev') : dd = arys(dd,3,/stddev,count=count)			
			else                     : dd = arys(dd,3,/mean,count=count)
		
		endcase
		
		return,temporary(ndim gt 2 ? reform(dd,[dim[0:ndim-2],7],/overwrite) : dd)			
		end
									
	struct_set(_ex,'diurnal') : begin
		
		dd = struct_set(_ex,'robust') ? arys(dd,n1,hh,/reform_hourly_robust,otflag=dy1) : arys(dd,n1,hh,/reform_hourly,otflag=dy1)
		
		case 1 of
		
			struct_set(_ex,'total')  : dd = arys(dd,3,/total,count=count)
			struct_set(_ex,'min')    : dd = arys(dd,3,/min,count=count)
			struct_set(_ex,'max')    : dd = arys(dd,3,/max,count=count)
			struct_set(_ex,'stddev') : dd = arys(dd,3,/stddev,count=count)			
			else                     : dd = arys(dd,3,/mean,count=count)
		
		endcase		
						
		rr = temporary(ndim gt 2 ? reform(dd,[dim[0:ndim-2],24],/overwrite) : dd)		
		end	
						
	struct_set(_ex,'total')  : rr = var_set(n1) ? total(dd,n1,/nan) : total(dd,/nan)		
	struct_set(_ex,'mean')   : rr = keyword_set(count) ? data_check(mean(dd,dim=n1,/nan),total(finite(dd),n1) lt (count gt 1 ? count : count*dim[n1-1]),nan) : mean(dd,dim=n1,/nan)
	struct_set(_ex,'max')    : rr = keyword_set(count) ? data_check(max(dd,dim=n1,/nan),total(finite(dd),n1) lt (count gt 1 ? count : count*dim[n1-1]),nan) : max(dd,dim=n1,/nan)		
	struct_set(_ex,'min')    : rr = keyword_set(count) ? data_check(min(dd,dim=n1,/nan),total(finite(dd),n1) lt (count gt 1 ? count : count*dim[n1-1]),nan) : min(dd,dim=n1,/nan)	
	struct_set(_ex,'stddev') : rr = struct_set(_ex,'zero') ? data_check(stddev(dd,dim=n1,/nan),arys(finite(dd),n1,/total) eq 1,0) : stddev(dd,dim=n1,/nan)
	struct_set(_ex,'median') : rr = var_set(n1) ? median(dd,dim=n1) : median(dd)		
									
	struct_set(_ex,'ascend') : begin
						
		dim2 = size((dd=ary(dd,n1,/forward)),/dim)												
		rr = dd[(oidx=ary(ss[transpose((idx(fix((ss=sort(dd))/dim2[0]),lindgen(dim2[1]),/point,/list)).toarray(/no_copy))],n1,dim,/forward,/restore))]
		end
		
	struct_set(_ex,'descend') : begin
	
		dim2 = size((dd=ary(dd,n1,/forward)),/dim)						
		dd = dd[ss[transpose((idx(fix((ss=sort(dd))/dim2[0]),lindgen(dim2[1]),/point,/list)).toarray(/no_copy))]]								
		oidx = reverse(ary((rebin(lindgen(dim2[0])+dim2[0],dim2)+rebin(transpose(-total(~finite(dd),1)),dim2)) mod dim2[0] + rebin(transpose(lindgen(dim2[1])*dim2[0]),dim2),n1,dim,/forward,/restore),n1)
		rr = dd[oidx]	
		end
		
	struct_set(_ex,'whisker') : begin
		
		dim2 = size((dd=ary(dd,n1,/forward)),/dim)		
		ss = ss[transpose((idx(fix((ss=sort(dd))/dim2[0]),lindgen(dim2[1]),/point,/list)).toarray(/no_copy))]						
		rr1 = dd[(oidx1=reform(ss[ceil((total(finite(dd[ss]),1)-1.)*(percentile=0.25))+lindgen(dim2[1])*dim2[0]],dim[where(~idx([n1-1],/mask,count=ndim))]))]
		rr2 = dd[(oidx2=reform(ss[ceil((total(finite(dd[ss]),1)-1.)*(percentile=0.5 ))+lindgen(dim2[1])*dim2[0]],dim[where(~idx([n1-1],/mask,count=ndim))]))]
		rr3 = dd[(oidx3=reform(ss[ceil((total(finite(dd[ss]),1)-1.)*(percentile=0.75))+lindgen(dim2[1])*dim2[0]],dim[where(~idx([n1-1],/mask,count=ndim))]))]
				
		rr = replicate(struct_make(['min','p25','median','p75','max'],!values.f_nan),size(rr1,/dim))
		
		rr.min    = min(_dd,dim=n1,/nan)
		rr.p25    = rr1
		rr.median = rr2
		rr.p75    = rr3
		rr.max    = max(_dd,dim=n1,/nan)
		
		end	
				
	struct_set(_ex,'percentile') : begin
	
		dim2 = size((dd=ary(dd,n1,/forward)),/dim)		
		ss = ss[transpose((idx(fix((ss=sort(dd))/dim2[0]),lindgen(dim2[1]),/point,/list)).toarray(/no_copy))]						
		rr = dd[(oidx = reform(ss[ceil((total(finite(dd[ss]),1)-1.)*(percentile=n2/100.))+lindgen(dim2[1])*dim2[0]],dim[where(~idx([n1-1],/mask,count=ndim))]))]			
		end
		
	struct_set(_ex,'interpol') : begin
	
		dim2 = size((dd=ary(dd,(n1=var_set(n1,ina=ndim)),/backward)),/dim)		
		for i=0L,dim2[0]-1 do if total((xx=finite(dd[i,*]))) ne dim2[1] then dd[i,*] = interpol(dd[i,where(xx)],where(xx),findgen(dim2[1]))
					
		rr = ary(temporary(dd),n1,dim,/backward,/restore)	
		end
		
	struct_set(_ex,'reform_hourly_robust') : begin
	
		if min(strlen(str(var_set(n1,ina=0))),max=_mx) ne 10 or _mx ne 10 then  message,'USAGE: rr = arys(data,tflag,/OPTION) TFLAG=YYYYMMDDHH'
				
		ot = date(date(min(n1)),date(max(n1)),/make)		
		dd = ary(dd,ndim,/backward,odim=dim2)
		
		hh = (nn=max(var_set(n2,ina=0))-23) gt 0 ? n2-nn : var_set(n2,ina=0)		
		if nn gt 0 then dd = shift(dd,[0,-nn])
					
		rr = reform(data_check(dd[*,(xx=idx(n1,date(min(ot)+'00',max(ot)+'23',/make),/point))],xx eq -1,dim=2,nan),[dim2[0],24,n_elements(ot)],/overwrite)						
		rr = var_set(n2) ? data_check(rr,hh,/index,dim=2) : temporary(rr)								
		end
		
	struct_set(_ex,'reform_hourly') : begin
	
		if min(strlen(str(var_set(n1,ina=0))),max=_mx) ne 10 or _mx ne 10 then  message,'USAGE: rr = arys(data,tflag,/OPTION) TFLAG=YYYYMMDDHH'
						
		ot = date(date(min(n1)),date(max(n1)),/make)				
		dd = ary(dd,ndim,/backward,odim=dim2)
		
		hh = (nn=max(var_set(n2,ina=0))-23) gt 0 ? n2-nn : var_set(n2,ina=0)		
		if nn gt 0 then dd = shift(dd,[0,-nn])
		
		if (x1=fix(date(min((tflag=n1)),/cut,/hour))) ne 0 then dd = [[replicate(nan,[dim2[0],x1])],[dd]]									
		if (x2=23-fix(date(max(tflag),/cut,/hour))) ne 0 then dd = [[dd],[replicate(nan,[dim2[0],x2])]]
		
		rr = reform(dd,[dim2[0],24,n_elements(ot)],/overwrite)						
		rr = var_set(n2) ? data_check(rr,hh,/index,dim=2) : temporary(rr)								
		end
				
	struct_set(_ex,'reform_weekly') : begin
	
		if min(strlen(str(var_set(n1,ina=0))),max=_mx) ne 8 or _mx ne 8 then  message,'USAGE: rr = arys(data,tflag,/OPTION) TFLAG=YYYYMMDD'
		
		dd = ary(dd,ndim,/backward,odim=dim2)								
		xx = date(n1,/weekday)
				
		if (x1=xx[0]) ne 0 then dd = [[replicate(nan,[dim2[0],x1])],[dd]]
		if (x2=6-xx[dim2[1]-1]) ne 0 then dd = [[dd],[replicate(nan,[dim2[0],x2])]]
			
		return,reform(dd,[dim2[0],7,n_elements(dd)/(7*dim2[0])],/overwrite)
		end			
		
	struct_set(_ex,'reform_monthly') : begin
	
		if min(strlen(str(var_set(n1,ina=0))),max=_mx) ne 8 or _mx ne 8 then  message,'USAGE: rr = arys(data,tflag,/OPTION) TFLAG=YYYYMMDD'
		
		ot = date(date(min(n1),/cut,/year,/month),date(max(n1),/cut,/year,/month),/make)				
		dd = ary(dd,ndim,/backward,odim=dim2)				
		return,reform(data_check(dd[*,(xx=idx(n1,ary(ot,nx=31)+ary(str(indgen(31)+1,digit=2),ny=n_elements(ot)),/point))],xx eq -1,dim=2,nan),[dim2[0],31,n_elements(ot)],/overwrite)
		end		
				
	struct_set(_ex,'local_time') : begin
		
		nd1 = ndim eq 1 ? 1 : product(dim[0:ndim-2])		
		nt1 = n_elements((tflag1=n1))
		nt2 = n_elements((tflag2=var_set(n3,ina=n1)))		
		dt  = struct_read(_ex,'timezone',0) ? n2 : -round(((lon = n2 mod 360.)*(lon le 180)+(lon-360)*(lon gt 180))/15.)*(struct_read(_ex,'backward',0) ? -1 : 1)

		tflag1 = [date(date(min(tflag1),-1,/incr,/day),24,/make,/hour),tflag1,date(date(max(tflag1),1,/incr,/hour),24,/make,/hour)]
		dim2   = size((dd=[[replicate(nan,[nd1,24])],[reform(dd,[nd1,nt1],/overwrite)],[replicate(nan,[nd1,24])]]	),/dim)		
		
		dd = data_check(dd[[(ii=lindgen(dim2)+rebin(ary(dt,count=nd1),dim2)*nd1)]],ii lt 0 or ii ge product(dim2),nan)		
		dd = dd[*,[(ii=idx(tflag1,tflag2,/point))]]		
		rr = reform(data_check(temporary(dd),rebin(transpose(ii),[nd1,nt2]) eq -1,nan),[dim[0:ndim-2],nt2])					
		end
				
	struct_set(_ex,'moving_average') : begin
	
		nmove = n_elements((nmove=var_set(n1,ina=[0,7]))) eq 1 ? [0,nmove-1] : nmove												
		dm = size((dd=reform(dd,[ndim eq 1 ? 1 : product(dim[0:ndim-2]),dim[ndim-1]],/overwrite)),/dim)		
		dd = [[replicate(nan,[dm[0],(nn=max(abs(nmove)))])],[temporary(dd)],[replicate(nan,[dm[0],nn])]]
		dd = data_check(dd,~(ii=finite(dd)),0.)
		
		for i=nmove[0],nmove[1] do begin
				
			ddd = var_set(ddd) ? ddd + shift(dd,[0,-i]) : shift(dd,[0,-i])
			iii = var_set(iii) ? iii + shift(ii,[0,-i]) : shift(ii,[0,-i])
				
		endfor
				
		rr = data_check(ddd/iii,iii lt var_set(count,ina=5),nan)		
		rr = reform(rr[*,nn:nn+dm[1]-1],dim,/overwrite)					
		end
				
	else : message,'NO OPTION specified'

endcase

return,rr
end
