;-------------------------------------------------------------------------------

	pro arrow2,x0,y0,x1,y1,color=color,hsize=hsize,thick=thick,hthick=hthick, $
	    solid=solid,resize=resize,_extra=_ex

;-------------------------------------------------------------------------------

COMPILE_OPT idl2
ON_ERROR, 2

n = min([n_elements(x0),n_elements(x1),n_elements(y0),n_elements(y1)])

if var_set(thick)  then thick = array(thick,count=n) else thick = replicate(1.,n)
if var_set(hthick) then hthick = array(hthick,count=n) else hthick = thick 
if var_set(hsize)  then arrowsize = array(hsize,count=n) else arrowsize = !d.x_size/64. * (hthick/2. > 1)
if var_set(color)  then color = array(color_load(/get,color),count=n) else color = array(!p.color,count=n)

mcost = -.866d		;We use 30 degrees for head angle
sint  = .500d
msint = - sint

for i=0L, n-1 do begin	

	p = [[x0[i], y0[i]],[x1[i], y1[i]]]

	xp0 = p[0,0]
	xp1 = p[0,1]
	yp0 = p[1,0]
	yp1 = p[1,1]

	dx = xp1 - xp0
	dy = yp1 - yp0
	zz = sqrt(dx^2d + dy^2d)	;Length

	if zz gt 0 then begin
		dx = dx/zz		;Cos th
		dy = dy/zz		;Sin th
	endif else begin
		dx = 1.
		dy = 0.
		zz = 1.
	endelse
	
	if arrowsize[i] gt 0 then a = arrowsize[i] $  ;a = length of head
	else a = -zz * arrowsize[i]
		
	if keyword_set(resize) then if zz le resize then a = zz * arrowsize[i] / resize < arrowsize[i]		
	
	xxp0 = xp1 + a * (dx*mcost - dy * msint)
	yyp0 = yp1 + a * (dx*msint + dy * mcost)
	xxp1 = xp1 + a * (dx*mcost - dy * sint)
	yyp1 = yp1 + a * (dx*sint  + dy * mcost)

	if keyword_set(solid) then begin	;Use polyfill?
	  b = a * mcost*.9d	;End of arrow shaft (Fudge to force join)
	  plots, [xp0, xp1+b*dx], [yp0, yp1+b*dy], /DEVICE, $
		COLOR = color[i], THICK = thick[i],_extra=_ex
	  polyfill, [xxp0, xxp1, xp1, xxp0], [yyp0, yyp1, yp1, yyp0], $
		/DEVICE, COLOR = color[i],_extra=_ex
	endif else begin
	
	  plots, [xp0, xp1], [yp0, yp1], /DEVICE, COLOR = color[i], THICK = thick[i],_extra=_ex
	  plots, [xxp0,xp1,xxp1],[yyp0,yp1,yyp1], /DEVICE, COLOR = color[i], $
			THICK = hthick[i],_extra=_ex
	endelse
	ENDFOR
end
