;-------------------------------------------------------------------------------
;	NAME
;		array_indices_reverse
;
;	PURPOSE
;		to convert multi-D indices to 1-D indices (reverse of array_indices)
;
;	USAGE
;		ii = array_indices_reverse(array,index[,/dimensions][,/L64])
;
;	INPUT
;		array : data array or dim( /dimensions)
;		index : indices ([n_dim,n_indices])
;
;	KEYWORD
;		dimensions : array it not data array but a array dimension
;		L64 : use long64
;
;	AUTHOR
;		Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function array_indices_reverse,_dim,ind,dimensions=dimensions,l64=l64

;-------------------------------------------------------------------------------

dim = keyword_set(dimensions) ? _dim : size(_dim,/dim)

for i=0,n_elements(dim)-1 do j = i eq 0L ? ind[0,*] : j + ind[i,*]*product(keyword_set(l64) ? long64(dim[0:i-1]) : long(dim[0:i-1]),/preserve_type)

return,reform(j)
end


