;-------------------------------------------------------------------------------
;	NAME
;		array2
;
;	PURPOSE
;		To perform array operation
;
;	USAGE
;		rr = array2(data,/uniq)
;		rr = array2(dtaa,/sort)
;		rr = array2(data,/flat)
;		rr = array2(data,ndim,/reverse) (ndim=1,2,...)
;		rr = array2(data,/boundary) (counter-clockwise)
;			minfo = aqm_grid(domain='5x',olon=lon,olat=lat)
;			plot,array2(lon,/boundary),array2(lat,/boundary)
;		rr = array2(data,ndim,/forward) 
;			AA              FLOAT     = Array[4, 5, 3, 2]
;			IDL> help,array2(aa,3,/forward)
;			<Expression>    FLOAT     = Array[3, 40]
;
;		rr = array2(data,3,/backward) 	
;			AA              FLOAT     = Array[4, 5, 3, 2]
;			IDL> help,array2(aa,3,/backward)
;			<Expression>    FLOAT     = Array[40, 3]
;		rr = array2(data,ndim,dim,/backward,/restore)
;		rr = array2(data,ndim,dim,/forward,/restore)
;		rr = array2(data,/plane)
;			AA              FLOAT     = Array[4, 5, 3, 2]
;			IDL> help,(bb=array2(aa,/plane))
;			BB              FLOAT     = Array[4, 5, 6]
;		rr = array2(data,nx=5)
;		rr = array2(data,ny=3)
;		rr = array2(data,nx=3,ny=2)
;		rr = array2(data,ix=ix,iy=iy)
;
;
;	INPUT
;
;
;
;
;
;
;
;
;
;
;
;
;	AUTHOR	
;		2014-01-14 Hyun Cheol Kim (hyun.kim@noaa.gov) rewritten from array.pro
;-------------------------------------------------------------------------------

	function array2,_dd,n1,n2,n3,n4,overwrite=overwrite,$
	         uniq=_uniq,sort=_sort,flat=flat,reverse=_reverse,$
	         nx=nx,ny=ny,count=count,plane=plane,boundary=boundary,$
		 ix=ix,iy=iy,$
		 track=track,curtain=curtain,$
		 add=add,extend=extend,slide=slide,$
		 up=up,down=down,right=right,left=left,$
		 forward=forward,backward=backward,restore=_restore,$
		 odim=odim,oxx=oxx
	         	
;-------------------------------------------------------------------------------

ndim = n_elements((dim=size(_dd,/dim)))
nd   = n_elements(_dd)
dd   = keyword_set(overwrite) ? temporary(_dd) : _dd

case 1 of

	keyword_set(_uniq) : return,dd[uniq(dd,sort(dd))]
	keyword_set(_sort) : return,dd[sort(dd)]								
	keyword_set(flat)  : return,reform(dd,nd,/overwrite)
	keyword_set(_reverse) : return,reverse(dd,n1,/overwrite)

	keyword_set(boundary) : begin	
	
		dd = array2(dd,/plane,/overwrite,odim=dim1)	
		ni = n_elements((ii=[lindgen(dim[0]),lindgen(dim[1]-1)*dim[0]+2*dim[0]-1,dim[0]*dim[1]-2-lindgen(dim[0]-1),dim[0]*(dim[1]-1)-lindgen(dim[1]-1)*dim[0]-dim[0]]))
		ii = rebin(ii,[ni,dim1[2]],/sample)+array2(lindgen(dim1[2])*product(dim1[0:1]),nx=ni)	
		odim = size((rr=(ndim gt 2 ? reform(dd[ii],[ni,dim[2:*]],/overwrite) : dd[ii])),/dim)
		end
		
	var_set(forward,_restore)  : odim = size((rr=transpose(reform(dd,n2[[shift(indgen(n1),1),n1 eq n_elements(n2) ? !null : indgen(n_elements(n2)-n1)+n1]],/overwrite),[shift(indgen(n1),-1),n1 eq n_elements(n2) ? !null : indgen(n_elements(n2)-n1)+n1])),/dim)
	var_set(backward,_restore) : odim = size((rr=transpose(reform(dd,n2[[n1 eq 1 ? !null : indgen(n1-1),shift((indgen(n_elements(n2)))[n1-1:*],-1)]]),[n1 eq 1 ? !null : indgen(n1-1),shift((indgen(n_elements(n2)))[n1-1:*],1)])),/dim)		
	keyword_set(forward)       : odim = size((rr=reform(transpose(dd,[n1-1,(xx1=where(~idx([n1-1],/mask,count=n_elements(dim))))]),[dim[n1-1],product(dim[xx1])],/overwrite)),/dim)		
	keyword_set(backward)      : odim = size((rr=reform(transpose(dd,[(xx1=where(~idx([n1-1],/mask,count=n_elements(dim)))),n1-1]),[product(dim[xx1]),dim[n1-1]],/overwrite)),/dim)
	keyword_set(plane)         : odim = size((rr=ndim eq 1 ? reform(dd,[nd,1,1]) : ndim eq 2 ? reform(dd,[dim,1]) : reform(temporary(dd),[dim[0:1],product(dim)/product(dim[0:1])])),/dim)		
						
	var_set(nx,ny)       : return,dd[reform(rebin(transpose(lindgen(nd)),[long(ny)*long(nx),nd],/sample),[nx,ny,nd],/overwrite)]			
	var_set(ny)          : return,dd[rebin(lindgen(nd),nd,ny,/sample)]
	var_set(nx)          : return,dd[rebin(transpose(lindgen(nd)),nx,nd,/sample)] 
	var_set(ix,iy)       : return,reform(dd[array2(ix+iy*dim[0],ny=product(dim[2:*]))+array2(lindgen(product(dim[2:*]))*product(dim[0:1]),nx=n_elements(ix))],[n_elements(ix),dim[2:*]],/overwrite)
	var_set(count)       : return,dd[(array(lindgen(nd),ny=long(count[0]/nd)+1))[0:count[0]-1]]
	keyword_set(track)   : return,interpolate(interpolate(transpose(dd,[3,0,1,2]),n1,n2,n3),n4,indgen(n_elements(n1)))
	keyword_set(curtain) : return,transpose(interpolate(transpose(dd,[2,0,1,3]),n1,n2,n3))
	
	keyword_set(add) : begin
	
		dd = array2(dd,/plane,/overwrite,odim=dim1)		
		ii = lindgen(dim[0:1])
		
		if keyword_set(up)    then ii = [[ii],[ii[*,(size(ii,/dim))[1]-1]]]								
		if keyword_set(down)  then ii = [[ii[*,0]],[ii]]				
		if keyword_set(right) then ii = [ii,ii[(size(ii,/dim))[0]-1,*]]		
		if keyword_set(left)  then ii = [ii[0,*],ii]
		
		ii = rebin(ii,[(dim2=size(ii,/dim)),dim1[2]],/sample)+array2(lindgen(dim1[2])*product(dim[0:1]),nx=dim2[0],ny=dim2[1],/overwrite)										
		odim = size((rr=n_elements(dim) gt 2 ? reform(dd[ii],[dim2[0:1],dim[2:*]],/overwrite) :  reform(dd[ii],dim2[0:1],/overwrite)),/dim)
		end
		
	keyword_set(extend) : begin
	
		dd = array2(dd,/plane,/overwrite,odim=dim1)		
		
		if keyword_set(right) then dd = [dd,2*dd[(size(dd,/dim))[0]-1,*,*]-dd[(size(dd,/dim))[0]-2,*,*]]
		if keyword_set(left)  then dd = [2*dd[0,*,*]-dd[1,*,*],dd]				
		if keyword_set(down)  then dd = [[[2*dd[*,0,*]-dd[*,1,*]]],[dd]]
		if keyword_set(up)    then dd = [[dd],[[2*dd[*,(size(dd,/dim))[1]-1,*]-dd[*,(size(dd,/dim))[1]-2,*]]]]
		
		odim = size((rr=n_elements(dim) gt 2 ? reform(dd,[(size(dd,/dim))[0:1],dim[2:*]],/overwrite) : temporary(dd)))
		end		
	
endcase

return,rr
end
