;-------------------------------------------------------------------------------

	function aqm_traj_file,_tflag,file=file,domain=domain,minfo=minfo,renew=renew,global=global
	
;-------------------------------------------------------------------------------

nday  = 2d
minfo = aqm_grid(file=file,domain=domain,minfo=minfo,omid=mid,olon=lon,olat=lat) 
odir  = path_check(keyword_set(global) ? path_check(getenv('HOME'),'data','traj') : 'save',/make)
save  = path_check(odir,str(/join,del='.','traj',mid,fix(nday),_tflag[0],'ncf'))

if file_renew(save,renew=renew) then begin

	message,/info,str(/join,'NOFILE',save)
	if ~var_set(file) then return,''

	dtime = 10d	
	ntime = nday/(dtime/(24d*3600d))
	tflag = date(date(_tflag[0],-nday*24,/incr),_tflag[0],/make)
	
	if ~keyword_set((ws=rd_m3(file,var='WSPD10',tflag=tflag))) then return,''		
	if total(finite(ws))/n_elements(ws) lt 0.9 then return,''
				
	;ws = aryn(ws,/interpol)
	;wd = aryn(rd_m3(file,var='WDIR10',tflag=tflag),/interpol)
	
	wd = rd_m3(file,var='WDIR10',tflag=tflag)
	
	uwind = cvdat(ws,wd,/uwind,ovwind=vwind)
	
	map_structure = map_proj_init(3,sphere_radius=minfo.r,standard_par1=minfo.lat1,standard_par2=minfo.lat2,center_longitude=minfo.lon0,center_latitude=minfo.lat0)
	out = map_proj_forward(lon,lat,map_structure=map_structure)
	xx = reform(out[0,*])
	yy = reform(out[1,*])
		
	mask = where(ary(lindgen(minfo.nx,minfo.ny),/boundary))		
	ii = 0
	
	for i=0L,ntime do begin
	
		if ((i mod (3600d/dtime)) eq 0) or (i eq 0) then begin
		
			str_progress,i,ntime,message=str(/join,'% Calculating TRAJ',_tflag)
		
			uw = uwind[*,*,0,ii]
			vw = vwind[*,*,0,ii]
		
			uw[mask] = !values.f_nan
			vw[mask] = !values.f_nan
							
			rxx = var_set(rxx) ? [rxx,xx] : [xx]
			ryy = var_set(ryy) ? [ryy,yy] : [yy]
		
			ii++

		endif
		
		ixx = (xx-minfo.x0)/minfo.dx
		iyy = (yy-minfo.y0)/minfo.dy
	
		xx -= uw[ixx,iyy]*dtime
		yy -= vw[ixx,iyy]*dtime
	
	endfor
	
	dim = [minfo.nx*minfo.ny,n_elements(tflag)]		
	rxx = reform(rxx,dim,/overwrite)
	ryy = reform(ryy,dim,/overwrite)
	out = map_proj_inverse(rxx,ryy,map_structure=map_structure)

	lon = reform(out[0,*],dim,/overwrite)
	lat = reform(out[1,*],dim,/overwrite)
	
	message,/info,str(/join,'SAVE',save)	
	ncdf_save,save,rxx,'x',ryy,'y',lon,'lon',lat,'lat'

endif 

return,save

end
