;-------------------------------------------------------------------------------
;	NAME
;		aqm_polyfillaa
;
;	PURPOSE
;		wrapper of polyfillaa by JD Smith
;		to separate cases needed big memory usage
;
;	USAGE
;		aqm_polyfillaa(ps,py,sx,sy,area=,polygons=,nn=)
;
;	INPUT
;		nn    : number of cut
;		
;		See polyfillaa
;
;	OUTPUT
;		See polyfillaa
;
;	AUTHOR
;		Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function aqm_polyfillaa,px,py,sx,sy,areas=areas,polygons=polys,nn=nn
	
;-------------------------------------------------------------------------------	

if ~var_set(nn) then nn = 200L

;if total(finite(px)) ne n_elements(px) then message,'ERROR'
;if total(finite(py)) ne n_elements(py) then message,'ERROR'
;if total(finite(sx)) ne n_elements(sx) then message,'ERROR'
;if total(finite(sy)) ne n_elements(sy) then message,'ERROR'

if (max(py)-min(py)) gt nn then begin

	yy = indgen(fix(sy/nn)+1)
	
	for iy=0L,n_elements(yy)-1 do begin

		cc = polyfillaa(double(px),double(py-nn*iy),long(sx),long(nn),areas=aa,polygons=pp)					
		
		if cc[0] ne -1 then cell = var_set(cell) ? [cell,cc+sx*nn*iy] : [cc+sx*nn*iy]
		if cc[0] ne -1 then area = var_set(area) ? [area,aa] : [aa]
			
	endfor
	
	if ~var_set(cell) then return,-1L
	
	xx = where(cell ge 0 and cell lt sx*sy,nxx)
	
	if nxx eq 0 then return,-1L
	
	cell = cell[xx]
	area = area[xx]
	
	xx = where(finite(area),nxx)
	
	if nxx eq 0 then return,-1L
	
	cell = cell[xx]
	area = area[xx]
	
	areas = area
	
	return,cell

endif else begin

	return,polyfillaa(px,py,sx,sy,areas=areas,polygons=polys)

endelse

end
