;-------------------------------------------------------------------------------

	pro aqm_plot_shp,file,domain=domain,minfo=minfo,renew=renew,$
	    skip_plot=skip_plot,_extra=_ex
	
;-------------------------------------------------------------------------------	

gr = aqm_grid(domain=domain,minfo=minfo,ominfo=minfo,olimit=limit,olon=lon0,olat=lat0,omid=mid)

opt = {xsize:500,ysize:500,display:!d.name,buffer:1.,save:path_check(getenv('HOME'),'data','save',str(/join,'aqm_plot_shp',file_name(file,tree=3),mid,del='-')+'.sav')}

if ~file_test(opt.save) or keyword_set(renew) then begin

		;
	
	set_plot,'z'
	device,set_resolution=[opt.xsize,opt.ysize],z_buffer=0

	case str(/low,minfo.proj) of

		'lcc' : map_set,/conic,minfo.lat0,minfo.lon0,standard_parallels=[minfo.lat1,minfo.lat2],limit=limit,position=p,/noerase,_extra=_ex
		'rll' : map_set,/merc,minfo.lat0,minfo.lon0,limit=limit,position=p,/noerase,_extra=_ex
		'll'  : map_set,/merc,0,0,limit=limit,position=p,/noerase,_extra=_ex
							
	endcase

		; read shapefile
	
	info   = rd_shp(file,/info)	
	entity = lindgen(info.n_entities)
	rr     = bytarr(info.n_entities)
	
	print
	message,/info,str(/join,'BUILD',opt.save)
	message,/info,str(/join,'Generating DATA...May take a few minutes...(First time only)')
	print

	myshape = obj_new('IDLffShape',file)

	image0 = tvrd()

	for i=0L,n_elements(entity)-1 do begin
	
		if i/1000. eq long(i/1000) then print,i,n_elements(entity)-1

		ent  = myshape -> IDLffShape::GetEntity(entity[i])
	
		lon = reform((*ent.vertices)[0,*])
		lat = reform((*ent.vertices)[1,*])
		cut = [*ent.parts,n_elements(lon)]
	
		if (min(lon) gt max(lon0)+opt.buffer) or (max(lon) lt min(lon0)-opt.buffer) or (min(lat) gt max(lat0)+opt.buffer) or (max(lat) lt min(lat0)-opt.buffer) then continue

		for icut=0L,n_elements(cut)-2 do plots,lon[cut[icut]:cut[icut+1]-1],lat[cut[icut]:cut[icut+1]-1],color=100
							
		image = tvrd()
	
		if ~array_equal(image0,image) then begin
					
			rr[i] = 1B		
			image0 = image
		
		endif

	endfor

	device,z_buffer=1
	set_plot,opt.display

	rr = where(rr)
	
	save,filename=opt.save,rr
	
	OBJ_DESTROY,myshape

endif

message,/info,str(/join,'READ',opt.save)
restore,opt.save

	;
	
if ~keyword_set(skip_plot) then plot_shp,file,entity=rr,/quiet,_extra=_ex

end
