;-------------------------------------------------------------------------------
;	NAME
;		aqm_plot_mapdata
;
;	PURPOSE
;		IDL function to read GIS shape file (*.shp) and extract data for given domain
;
;	USAGE
;		r = aqm_plot_mapdata(domain=domain|minfo=minfo,/make,/read,sdir=sdir,file=file,dl=dl)
;
;	INPUT
;		domain : domain nick name
;		minfo  : map information array
;		sdir   : source directory
;		file   : shape file name
;		dl     : minimum sector length
;
;	KEYWORD
;		make : extract data
;		read : find(download or make) and return data
;
;	AUTHOR
;		Hyun Cheol Kim 20080709 
;-------------------------------------------------------------------------------

 function aqm_plot_mapdata,domain=domain,minfo=minfo,$
          make=make,all=all,read=read,sdir=_sdir,file=file,dl=dl
 
;------------------------------------------------------------------------------- 

if var_set(_sdir) then sdir = _sdir else sdir = path_check(getenv('HOME'),'data','map')
if not file_test(sdir,/dir) then file_mkdir,sdir

grid = aqm_grid(domain=domain,minfo=minfo,olon=lon,olat=lat,ominfo=minfo,omid=mid)
grid = {max_lon:max(lon),min_lon:min(lon),max_lat:max(lat),min_lat:min(lat)}

if ~var_set(dl) then dl = fix(minfo.dx/10.)

	; main

case 1 of

	keyword_set(make) : begin
	
		if file_test(file[0]) then begin
				
			result = replicate({lon:0.,lat:0.},10000)
			count  = 0L		
	
				; read shape file

			myshape = OBJ_NEW('IDLffShape',file[0])   

			myshape -> IDLffShape::GetProperty, N_ENTITIES      = n_entities
			myshape -> IDLffShape::GetProperty, ENTITY_TYPE     = entity_type
			myshape -> IDLffShape::GetProperty, N_ATTRIBUTES    = n_attributes 
			myshape -> IDLffShape::GetProperty, ATTRIBUTE_NAMES = attribute_names
			myshape -> IDLffShape::GetProperty, ATTRIBUTE_INFO  = attribute_info
    		
			for ient=0L, n_entities-1 do begin

				if ( ient mod 100 ) eq 0 then message,/info,str(/join,file_basename(file[0]),minfo.dx,':',ient,'/',n_entities-1)
				  
				attr = myshape -> IDLffShape::GetAttributes(ient)	
				ent  = myshape -> IDLffShape::GetEntity(ient)
					
				;domain_check = aqm_grid_index((*ent.vertices)[0,*],(*ent.vertices)[1,*],minfo=minfo,ninside=ninside)
					
				lon2 = reform((*ent.vertices)[0,*])
				lat2 = reform((*ent.vertices)[1,*])
				
				xx = where(lon2 ge grid.min_lon and lon2 le grid.max_lon and lat2 ge grid.min_lat and lat2 le grid.max_lat,ninside)
																			
				if ninside gt 0 then begin
	
					parts = [*ent.parts,n_elements(*ent.vertices)/2-1]
					nparts = n_elements(parts)
						
					for iparts=0L,nparts-2 do begin
					
						if dl eq 0 then begin
													
							for i=parts[iparts]+1,parts[iparts+1]-2 do begin
										
								x1 = (*ent.vertices)[0,i]
								y1 = (*ent.vertices)[1,i]
								
								result[count].lon = x1
								result[count].lat = y1
								
								count ++
								
								if count gt n_elements(result)/2. then begin

									temp = result
									result = replicate({lon:0.,lat:0.},n_elements(result)*2)
									result[0:n_elements(temp)-1] = temp
			
								endif
							endfor
							
							result[count].lon = !values.f_nan
							result[count].lat = !values.f_nan
							count ++
															
						endif else begin
		
							x0 = (*ent.vertices)[0,parts[iparts]]
							y0 = (*ent.vertices)[1,parts[iparts]]
				
							result[count].lon = x0
							result[count].lat = y0
									
							count = count + 1
					
							for i=parts[iparts]+1,parts[iparts+1]-2 do begin
										
								x1 = (*ent.vertices)[0,i]
								y1 = (*ent.vertices)[1,i]
			
								length = map_2points(x0,y0,x1,y1,/meters)
																		
								if length gt dl then begin
				
									result[count].lon = x1
									result[count].lat = y1
					
									count = count + 1
					
									x0 = x1
									y0 = y1
																
									if count gt n_elements(result)/2. then begin

										temp = result
										result = replicate({lon:0.,lat:0.},n_elements(result)*2)
										result[0:n_elements(temp)-1] = temp
			
									endif
																		
								endif
																							
							endfor
					
							result[count].lon = (*ent.vertices)[0,parts[iparts+1]-1]
							result[count].lat = (*ent.vertices)[1,parts[iparts+1]-1]
							count = count + 1
			
							result[count].lon = !values.f_nan
							result[count].lat = !values.f_nan
							count = count + 1
							
						endelse	
				
					endfor
		
				endif	
								  		
			endfor

			OBJ_DESTROY, myshape
			
			if count gt 5 then begin
			
				result = transpose(reform([result[0:count-2].lon,result[0:count-2].lat],[count-1,2]))
				
			endif else begin
			
				result = 0
			
			endelse	
				
										
			map_info = minfo
			save     = path_check(sdir,strjoin(['aqm_plot_map',strcompress(file_basename(file[0],'.shp'),/remove_all),mid,str(dl),'dat'],'.'))
		
			message,/info,str(/join,'[WRITING]',save)
		
			save,filename=save,result,map_info		
										
		endif else begin
		
			message,str(/join,'CANNOT FIND SHAPE FILE --',file[0])
				
		endelse
	
		end
		
		;...........................................................................
		
	keyword_set(read) : begin
	
		save = path_check(sdir,strjoin(['aqm_plot_map',strcompress(file_basename(file[0],'.shp'),/remove_all),mid,str(dl),'dat'],'.'))

		;if (file_info(save)).size eq 0 then spawn,'wget http://geossun2.geosc.uh.edu/web/hkim/data/map/'+file_basename(save)+' -O '+save
		if (file_info(save)).size eq 0 then if file_test(file[0]) then xx = aqm_plot_mapdata(/make,minfo=minfo,file=file[0],dl=dl)
														
		if file_test(save) then begin
		
			message,/info,str(/join,'[READ]',save)
	
			restore,save
		
			;if not array_equal(long(map_info),long(minfo)) then message,str(/join,'[WRONG MINFO]',minfo,'/',map_info)
			;if ~aqm_grid_mid(/check,map_info,minfo) then message,str(/join,"MINFO doesn't match")
		
			return,result			
		
		endif else begin
				
				message,/info,str(/join,'[NOFILE]',save)
				return,0
								
		endelse	

		end		
		
endcase
	
end			
		
