;-------------------------------------------------------------------------------
;	NAME
;		aqm_plot_map
;
;	PURPOSE
;		IDL procedure to plot map
;
;	USAGE
;		aqm_plot_map,'america usa state county interstate high road',domain=domain|minfo=minfo,color=color
;
;	INPUT
;		type   : map type to draw ('america usa state county interstate high road')
;		domain : domain nick name
;		minfo  : map information array
;		dl     : minimum sector length
;		color  : line color (index or name)
;		sdir   : source directory
;
;	KEYWORD
;		n/a
;
;	AUTHOR
;		Hyun Cheol Kim 20080709
;-------------------------------------------------------------------------------

	pro aqm_plot_map,_type,domain=domain,minfo=minfo,dl=dl,color=_color,thick=_thick,$
	    sdir=_sdir,mapdata=_mapdata,omapdata=mapdata,skip_plot=skip_plot,_extra=_ex

;-------------------------------------------------------------------------------
		
if var_set(_sdir) then sdir = _sdir else sdir = path_check(getenv('HOME'),'data','map')

if struct(/set,_mapdata) then begin	

	mapdata = _mapdata

endif else begin

		; map information
			
	minfo = aqm_grid_minfo(domain=domain,minfo=minfo)
	
		; set dl
		
	if ~var_set(dl) then dl = fix(minfo.dx/10)
		
		; map types and colors

	type  = n_elements(_type) eq 1 ? strsplit(_type,/extract) : _type
	ntype = n_elements(type)
	color = array(var_set(_color) ? _color : ['slategray','black'],count=ntype)		
	thick = array(var_set(_thick) ? _thick : 1.,count=ntype)
		
	mapdata = {minfo:minfo,type:type,ndata:ntype,color:color,thick:thick}	
	
	for itype=0L,ntype-1 do begin
		
		case str(/low,type[itype]) of
	
			'america'     : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','map_ll_Canada_Mexico_Cuba.shp'),minfo=minfo,dl=dl)
			'usa'         : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','statesp020.shp'),minfo=minfo,dl=dl)
			'state'       : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','statesp020.shp'),minfo=minfo,dl=dl)
			'states'      : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','statesp020.shp'),minfo=minfo,dl=dl)			
			'county'      : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','countyp020.shp'),minfo=minfo,dl=dl)
			'counties'    : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','countyp020.shp'),minfo=minfo,dl=dl)			
			'interstate'  : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','interstates.shp'),minfo=minfo,dl=dl)
			'interstates' : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','interstates.shp'),minfo=minfo,dl=dl)						
			'highway'     : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','US_Highways.shp'),minfo=minfo,dl=dl)
			'highways'    : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','US_Highways.shp'),minfo=minfo,dl=dl)			
			'road'        : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','STATE_ROUTES.shp'),minfo=minfo,dl=dl)
			'roads'       : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','STATE_ROUTES.shp'),minfo=minfo,dl=dl)			
			'river'       : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','rivers.shp'),minfo=minfo,dl=dl)
			'rivers'      : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','rivers.shp'),minfo=minfo,dl=dl)			
			'lake'        : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','lakes.shp'),minfo=minfo,dl=dl)
			'lakes'       : data = aqm_plot_mapdata(/read,file=path_check(sdir,'shape','lakes.shp'),minfo=minfo,dl=dl)			
			'adm0'        : data = aqm_plot_mapdata(/read,file=path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm1_lev0.shp'),minfo=minfo,dl=dl)
			'adm1'        : data = aqm_plot_mapdata(/read,file=path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm1_lev1.shp'),minfo=minfo,dl=dl)
			'adm2'        : data = aqm_plot_mapdata(/read,file=path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm_v1_lev2.shp'),minfo=minfo,dl=dl)
			'vrd'         : data = aqm_plot_mapdata(/read,file=path_check(getenv('HOME'),'data','GIS','vmap','trans-road-l.shp'),minfo=minfo,dl=dl)
			'vrdp'        : data = aqm_plot_mapdata(/read,file=path_check(getenv('HOME'),'data','GIS','vmap','trans-road-l-p.shp'),minfo=minfo,dl=dl)
																													
			else : data = 0
	
		endcase
										
		if keyword_set(data) then mapdata = struct(/merge,mapdata,struct(/make,str(type[itype]),data))
								
	endfor
		
endelse	

	; plot
	
if ~keyword_set(skip_plot) then begin

	for imapdata=0l,mapdata.ndata-1 do begin
	
		data = struct(/read,mapdata,str(mapdata.type[imapdata]))
		
		if keyword_set(data) then plots,data,color=color_load(/get,mapdata.color[imapdata]),thick=mapdata.thick[imapdata],_extra=_ex
		
		case str(/low,mapdata.type[imapdata]) of
		
			'america-f'     : aqm_plot_shp,path_check(sdir,'shape','map_ll_Canada_Mexico_Cuba.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'usa-f'         : aqm_plot_shp,path_check(sdir,'shape','statesp020.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'state-f'       : aqm_plot_shp,path_check(sdir,'shape','statesp020.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'states-f'      : aqm_plot_shp,path_check(sdir,'shape','statesp020.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'county-f'      : aqm_plot_shp,path_check(sdir,'shape','countyp020.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'counties-f'    : aqm_plot_shp,path_check(sdir,'shape','countyp020.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'interstate-f'  : aqm_plot_shp,path_check(sdir,'shape','interstates.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'interstates-f' : aqm_plot_shp,path_check(sdir,'shape','interstates.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])			    
			'highway-f'     : aqm_plot_shp,path_check(sdir,'shape','US_Highways.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'highways-f'    : aqm_plot_shp,path_check(sdir,'shape','US_Highways.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])   
			'road-f'        : aqm_plot_shp,path_check(sdir,'shape','STATE_ROUTES.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'roads-f'       : aqm_plot_shp,path_check(sdir,'shape','STATE_ROUTES.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'river-f'       : aqm_plot_shp,path_check(sdir,'shape','rivers.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'rivers-f'      : aqm_plot_shp,path_check(sdir,'shape','rivers.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'lake-f'        : aqm_plot_shp,path_check(sdir,'shape','lakes.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'lakes-f'       : aqm_plot_shp,path_check(sdir,'shape','lakes.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'adm0-f'        : aqm_plot_shp,path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm1_lev0.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'adm1-f'        : aqm_plot_shp,path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm1_lev1.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'adm2-f'        : aqm_plot_shp,path_check(getenv('HOME'),'data','GIS','gadm','v1','gadm_v1_lev2.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'vrd-f'         : aqm_plot_shp,path_check(getenv('HOME'),'data','GIS','vmap','trans-road-l.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			'vrdp-f'        : aqm_plot_shp,path_check(getenv('HOME'),'data','GIS','vmap','trans-road-l-p.shp'),minfo=mapdata.minfo,color=color_load(/get,mapdata.color[imapdata])
			else :
		
		endcase
					
	endfor	
	
endif	

omapdata = mapdata

end
