;-------------------------------------------------------------------------------
;	NAME
;		aqm_plot_info
;
;	PURPOSE
;		return basic information for aqm_plot*
;
;	USAGE
;		info = aqm_plot_info(var=)
;	
;	INPUT
;		var : variable name
;
;	AUTHOR
;		2010-01-14 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function aqm_plot_info,var=_var,type=type
	
;-------------------------------------------------------------------------------	

case 1 of

	var_set(_var) : begin
	
		if var_set(type) then var = var+'_'+str(type) else var = _var

		case str(/up,var) of

		'O3'      : r = {ct:{ndiv2:[6,3,4,4,5],scolor:'light cyan'},ci:{div1:[0,60,75,95,115,300],div2:[10,20,30,40,50,65,70,80,85,90,100,105,110,120,130,140,150]}}
		'O3_2'    : r = {ct:{ndiv2:[7,4,4,4,6],scolor:'light cyan'},ci:{div:[0,5,15,25,35,45,55,65,70,75,80,85,90,95,100,105,110,115,120,125,135,145,155,165,175,185]}}

		'PM2P5'   : r = {ct:{ndiv2:[5,4,4,5,5],scolor:'light cyan'},ci:{div:[0,3,6,9,12,15,20,25,30,35,40,45,50,55,70,85,100,120,140,160,180,200,220,250]}}
		
		'PM2.5'   : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:[0,3,6,9,12,15,20,25,30,35,40,45,50,55,60,65,75,90,110,130,150,170,190,210,230,250]}}
		'OC'      : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'POC'     : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'SOC'     : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'EC'      : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'ASO4'    : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'ANH4'    : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'ANO3'    : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}
		'A25J'    : r = {ct:{ndiv2:[5,5,5,5,5],scolor:'light cyan'},ci:{div:indgen(26)}}		
		'NO'      : r = {ct:{ndiv2:[5,4,5,5,5],scolor:'light cyan'},ci:{div:[0,0.2,0.4,0.6,0.8,1,2,3,4,5,6,7,8,9,10,20,40,60,80,100,200,400,600,800,1000]}}
		'NO2'     : r = {ct:{ndiv2:[5,4,5,5,5],scolor:'light cyan'},ci:{div:[0,0.2,0.4,0.6,0.8,1,2,3,4,5,6,7,8,9,10,20,40,60,80,100,200,400,600,800,1000]}}
		'NOX'     : r = {ct:{ndiv2:[5,4,5,5,5],scolor:'light cyan'},ci:{div:[0,0.2,0.4,0.6,0.8,1,2,3,4,5,6,7,8,9,10,20,40,60,80,100,200,400,600,800,1000]}}
		'PBL'     : r = {ct:{color:['light gray','gray','sienna','orange','yellow','green','sky blue'],ecolor:'white',ndiv2:[1,1,5,5,5,5,5]},ci:{div:[0,20,50,100,200,300,400,500,600,700,800,900,1000,1200,1400,1600,1800,2000,2200,2400,2600,2800,3000,3200,3400,3600,3800,4000]}}		
		'PBL2'    : r = {ct:{color:['light gray','gray','sienna','orange','yellow','green','sky blue'],ecolor:'white',ndiv2:[1,1,5,5,5,5,5]},ci:{div:[0,20,50,100,200,300,400,500,600,700,800,900,1000,1200,1400,1600,1800,2000,2200,2400,2600,2800,3000,3200,3400,3600,3800,4000]}}				
		;'PBL'    : r = {ct:{color:['light gray','gray','green','yellow','orange','red','purple'],ecolor:'black',ndiv2:[1,1,5,5,5,5,5]},ci:{div:[0,20,50,100,200,300,400,500,600,700,800,900,1000,1200,1400,1600,1800,2000,2200,2400,2600,2800,3000,3200,3400,3600,3800,4000]}}
		'TEMP1P5' : r = {ct:{color:['dodgerblue','skyblue','white','orange','fire brick'],ecolor:'purple',ndiv2:[5,5,5,5,5]},ci:{div:[10,12,14,16,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,37,39,41,43,45]}}
		'TEMP2'   : r =	{ct:{color:['darkgray','dodgerblue','skyblue','white','palegreen','yellow','orange','red'],ecolor:'purple',ndiv2:[5,5,5,5,5,5,5,5]},ci:{div:findgen(41)*2.-20.},cb:{div2:{nolabel:1}}}
		'TEMP2_1' : r = {ct:{color:['dodgerblue','skyblue','white','orange','fire brick'],ecolor:'purple',ndiv2:[5,5,5,5,5]},ci:{div:[10,12,14,16,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,37,39,41,43,45]-20}}
		'TEMP2_2' : r = {ct:{color:['dodgerblue','skyblue','white','orange','fire brick'],ecolor:'purple',ndiv2:[5,5,5,5,5]},ci:{div:[10,12,14,16,18,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,37,39,41,43,45]}}
		'WS'      : r = {ct:{ndiv2:[5,5,5,5],scolor:'light cyan'},ci:{div:indgen(21)},dot:1}
		'WSPD10'  : r = {ct:{ndiv2:[5,5,5,5],scolor:'light cyan'},ci:{div:indgen(21)}}		
		'WDIR10'   : r = {ct:{color:['gray','dodgerblue','skyblue','white','palegreen','yellow','orange','pink'],ecolor:'gray',ndiv2:[5,5,5,5,5,5,5,5]},cb:{div2:{nolabel:1}}}		
		'CFRAC'   : r = {ct:{color:['honeydew','light cyan','powder blue','sky blue','cornflower blue'],ndiv2:[4,4,4,4,4],ecolor:'navy'},ci:{div:indgen(21)/20.}}
		'SST'     : r = {ct:{ndiv2:[5,5,5,5],scolor:'light cyan'},ci:{div:indgen(21)+290}}
		
		'DIFF'    : r =	{use_diff:1}
																	
		else : r = 0

		endcase

		return,r
		
	end		
	
endcase	

end	
