

;-------------------------------------------------------------------------------

	function aqm_map_proj,_data1,_data2,domain=domain,minfo=_minfo, $
	         ll=ll,lcc=lcc,rll=rll,to_ll=to_ll,to_lcc=to_lcc,to_rll=to_rll, $
	         out1=out1,out2=out2,olon=olon,olat=olat,ololx,oly=oly, $
	         orx=orx,ory=ory,olimit=olimit
					 
;-------------------------------------------------------------------------------					 
					 
opt = {radius:6370997.}
gr  = aqm_grid(domain=domain,minfo=_minfo,ominfo=minfo)

	; input dimensions
	
dim1 = size(_data1,/dim)
dim2 = size(_data2,/dim)

	; input

case 1 of

	keyword_set(lcc) : begin

		map_structure = map_proj_init(3,sphere_radius=opt.radius,standard_par1=minfo.lat1,   $
		                standard_par2=minfo.lat2,center_longitude=minfo.lon0,center_latitude=minfo.lat0)

		r = map_proj_inverse(_data1,_data2,map_structure=map_structure)
    
		data1 = r[0,*]
		data2 = r[1,*]  
		end	
		  
	keyword_set(rll) : begin
  
		rlon0 = double(minfo.lon0) *!dtor
		rlat0 = double(minfo.lat0) *!dtor

		data1 = double(_data1)*!dtor
		data2 = double(_data2)*!dtor

		xx = rlon0 + atan(cos(data2)*sin(data1) / (cos(rlat0)*cos(data2)*cos(data1)-sin(rlat0)*sin(data2)))	    
		yy = asin(sin(rlat0)*cos(data2)*cos(data1)+cos(rlat0)*sin(data2))
    
		data1 = xx / !dtor
		data2 = yy / !dtor
 
		end
		
	keyword_set(ll) : begin
	
		data1 = _data1
		data2 = _data2
	
		end		
  
	else : message,str(/join,'[USAGE] choose /ll,/lcc,/rll')
	
endcase	

	; limit

if n_elements(dim1) eq 2 then begin
		
	onx    = dim1[0]
	ony    = dim1[1]	
	olon   = reform(data1,dim1)
	olat   = reform(data2,dim2)
	olimit = [olat[0,0],olon[0,0],olat[0,ony-1],olon[0,ony-1],olat[onx-1,ony-1],olon[onx-1,ony-1],olat[onx-1,0],olon[onx-1,0]]

endif

  ; convert to output

case 1 of

	keyword_set(to_lcc) : begin

		map_structure = map_proj_init(3,sphere_radius=opt.radius,standard_par1=minfo.lat1,   $
	                        standard_par2=minfo.lat2,center_longitude=minfo.lon0,center_latitude=minfo.lat0)

		out = map_proj_forward(data1,data2,map_structure=map_structure)

		out1 = out[0,*]
		out2 = out[1,*]

		olx = reform(out1,dim1)
		oly = reform(out2,dim2)    
		
		end  

		;...........................................................................
              
	keyword_set(to_rll) : begin
		     
		rlon0 = double(minfo.lon0) *!dtor
		rlat0 = double(minfo.lat0) *!dtor

		data1 = double(data1)*!dtor
		data2 = double(data2)*!dtor
       
		xx = atan((cos(data2)*sin(data1-rlon0))/(cos(rlat0)*cos(data2)*cos(data1-rlon0)+sin(rlat0)*sin(data2)))    
		yy = asin(cos(rlat0)*sin(data2)-sin(rlat0)*cos(data2)*cos(data1-rlon0))
		    
		out1 = xx / !dtor
		out2 = yy / !dtor
    
		orx = reform(out1,dim1)
		ory = reform(out2,dim2)
               
		end
		;...........................................................................
  
	else : begin
  
		out1 = data1
		out2 = data2
				
		end
  
endcase  

	; reform
   
if dim1[0] ne 0 then out1 = reform(out1,dim1)
if dim2[0] ne 0 then out2 = reform(out2,dim2)

	; return result
   
return,[transpose(array(out1,/flat)),transpose(array(out2,/flat))]
			
end
