;-------------------------------------------------------------------------------
;	PURPOSE
;		To convert local time to utc
;
;	USAGE
;		tflag = aqm_lt2utc(ltflag[,lon][,domain=,minfo=])
;
;		tflag = aqm_lt2utc(ltflag,lon)
;		tflag = aqm_lt2utc(ltflag,domain='5x')	
;
;	INPUT
;		ltflag : local time
;		lon    : longitude to check
;		domain/minfo : domain to check
;
; 	AUTHOR
;		2013-02-13 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function aqm_lt2utc,ltflag,_lon,domain=domain,minfo=minfo,add=add,backward=backward
	
;-------------------------------------------------------------------------------	

if ~var_set(_lon) then gr = aqm_grid(domain=domain,minfo=minfo,olon=_lon)
if ~var_set(add) then add = 1

lon   = [min(_lon),max(_lon)] mod 360
tflag = array(date(date(array(date(ltflag,/tflag_to_julday),ny=n_elements(lon))+(keyword_set(backward) ? -1 : 1)*array((-((lon*(lon le 180)+(lon-360)*(lon gt 180))/15.))/24d,nx=n_elements(ltflag)),/julday_to_tflag),/hh),/uniq)
tflag = date(date(min(tflag),-add,/incr,/hour),date(max(tflag),add,/incr,/hour),/make,/hour)

return,tflag

end
