;-------------------------------------------------------------------------------
;	NAME
;		aqm_grid_minfo
;
;	PURPOSE
;		short version of aqm_grid to minfo only
;
;	USAGE
;		minfo = aqm_grid_minfo(domain=domain,minfo=minfo,file=file)
;
;	INPUT
;		domain : domain nickname
;		minfo  : map information
;		file   : m3 file 
;		zoom   : If set, subtract subregion;		
;
;		minfo.add : if "minfo.add" exists, minfo will be added in available list
;
;	OUTPUT
;		omid : return map id
;
;	KEYWORD
;		n/a
;
;	AUTHOR
;		2012-05-30 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2014-08-27 added minfo.add
;-------------------------------------------------------------------------------

	function aqm_grid_minfo,input,file=_file,domain=_domain,minfo=_minfo,$
	         radius=radius,proj=proj,zoom=zoom,omid=omid,onx=onx,ony=ony
	
;-------------------------------------------------------------------------------

	; check input

if var_set(input) then _domain = input
if var_set(input) then if struct(/set,input) then _minfo = input
if var_set(input) then if file_test(input)   then _file = input

	; pre-defined grid information
		 
domains = {d04    :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  356000d  ,y0:-1228000d  ,dx:  4000d,dy:  4000d,nx:  83L,ny: 65L, r: 6370000d, proj:'lcc'},$
           d04d   :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  140000d  ,y0: -940000d  ,dx:  4000d,dy:  4000d,nx:  74L,ny: 65L, r: 6370000d, proj:'lcc'},$
           d12    :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  -12000d  ,y0:-1488000d  ,dx: 12000d,dy: 12000d,nx:  89L,ny: 89L, r: 6370000d, proj:'lcc'},$
           d36    :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:-2160000d  ,y0:-1836000d  ,dx: 36000d,dy: 36000d,nx: 133L,ny: 91L, r: 6370000d, proj:'lcc'},$
           e04    :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  140000d  ,y0:-1228000d  ,dx:  4000d,dy:  4000d,nx: 137L,ny:137L, r: 6370000d, proj:'lcc'},$
           e12    :{lon0:-100d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0: -660000d  ,y0:-1704000d  ,dx: 12000d,dy: 12000d,nx: 167L,ny:128L, r: 6370000d, proj:'lcc'},$     
           u36    :{lon0: -95d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:-2196000d  ,y0:-1566000d  ,dx: 36000d,dy: 36000d,nx: 123L,ny: 88L, r: 6370000d, proj:'lcc'},$
           u12    :{lon0: -95d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0: -396000d  ,y0: -486000d  ,dx: 12000d,dy: 12000d,nx: 211L,ny:142L, r: 6370000d, proj:'lcc'},$ 
           u04a   :{lon0: -95d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  804000d  ,y0: -306000d  ,dx:  4000d,dy:  4000d,nx: 139L,ny: 97L, r: 6370000d, proj:'lcc'},$ 
           u04b   :{lon0: -95d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0:  -60000d  ,y0:  198000d  ,dx:  4000d,dy:  4000d,nx: 283L,ny:199L, r: 6370000d, proj:'lcc'},$ 
           u04c   :{lon0: -95d   ,lat0:40d   ,lat1:30d ,lat2:60d ,x0: 1116000d  ,y0:  -30000d  ,dx:  4000d,dy:  4000d,nx: 238L,ny:238L, r: 6370000d, proj:'lcc'},$	   
 	   HI12   :{lon0:-157.5d ,lat0:20.53d,lat1:19d ,lat2:21d ,x0: -480000d  ,y0: -312000d  ,dx: 12000d,dy: 12000d,nx:  80L,ny: 52L, r: 6370000d, proj:'lcc'},$
           AK12   :{lon0:-148.6d ,lat0:63.2d ,lat1:57d ,lat2:63d ,x0:-1194000d  ,y0: -978000d  ,dx: 12000d,dy: 12000d,nx: 199L,ny:163L, r: 6370000d, proj:'lcc'},$	       
	   _3X    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:- 420000d  ,y0:-1716000d  ,dx: 12000d,dy: 12000d,nx: 268L,ny:259L, r: 6370000d, proj:'lcc'},$		    
	   _5X108 :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx:108000d,dy:108000d,nx:  50L,ny: 30L, r: 6370000d, proj:'lcc'},$
	   _5X36  :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx: 36000d,dy: 36000d,nx: 147L,ny: 89L, r: 6370000d, proj:'lcc'},$
	   _5X    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx: 12000d,dy: 12000d,nx: 442L,ny:265L, r: 6370000d, proj:'lcc'},$
 	   _7X    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2398000d  ,y0:-1598000d  ,dx:  4000d,dy:  4000d,nx:1199L,ny:799L, r: 6370000d, proj:'lcc'},$	       
           _9X    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx:  1000d,dy:  1000d,nx:5200L,ny:3200L,r: 6370000d, proj:'lcc'},$		 

           R36   : {lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2736000d  ,y0:-2088000d  ,dx: 36000d,dy: 36000d,nx: 148L,ny: 112L,r: 6370000d, proj:'lcc'},$
           R12   : {lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2736000d  ,y0:-2088000d  ,dx: 12000d,dy: 12000d,nx: 444L,ny: 336L,r: 6370000d, proj:'lcc'},$
           ETX4  : {lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0: -368000d  ,y0:-1592000d ,dx:  4000d,dy:  4000d,nx: 196L,ny: 268L,r: 6370000d, proj:'lcc'},$ 	   	   	   


	   Q108   :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx:108000d,dy:108000d,nx:  45L,ny: 30L, r: 6370000d, proj:'lcc'},$		
	   Q36    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx: 36000d,dy: 36000d,nx: 135L,ny: 90L, r: 6370000d, proj:'lcc'},$		
	   Q12    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx: 12000d,dy: 12000d,nx: 405L,ny:270L, r: 6370000d, proj:'lcc'},$		
	   Q04    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx:  4000d,dy:  4000d,nx:1215L,ny:810L, r: 6370000d, proj:'lcc'},$		
	   Q01    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2508000d  ,y0:-1716000d  ,dx:  1000d,dy:  1000d,nx:4860L,ny:3240L,r: 6370000d, proj:'lcc'},$		

           HOU4   :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0: -222000d  ,y0:-1302000d  ,dx:  4000d,dy:  4000d,nx: 160L,ny: 180L,r: 6370000d, proj:'lcc'},$		 
	   NCA12  :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-4308000d  ,y0:-4656000d  ,dx: 12000d,dy: 12000d,nx: 718L,ny: 776L,r: 6370000d, proj:'lcc'},$	      
	   NCA36  :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-4308000d  ,y0:-4656000d  ,dx: 36000d,dy: 36000d,nx: 240L,ny: 260L,r: 6370000d, proj:'lcc'},$	      
	   NCA108 :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-4308000d  ,y0:-4656000d  ,dx:108000d,dy:108000d,nx:  80L,ny:  85L,r: 6370000d, proj:'lcc'},$	      
	   
	   SJV4   :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2242000d  ,y0: -522000d  ,dx:  4000d,dy:  4000d,nx: 110L,ny: 160L,r: 6370000d, proj:'lcc'},$	    
	   
	   SC4    :{lon0:-120.5d ,lat0:37d   ,lat1:30d ,lat2:60d ,x0:-84000d    ,y0: -552000d  ,dx:  4000d,dy:  4000d,nx: 156L,ny: 102L,r: 6370000d, proj:'lcc'},$
	   SN4    :{lon0: -97d   ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:  658000d  ,y0:-1134000d  ,dx:  4000d,dy:  4000d,nx: 308L,ny: 244L,r: 6370000d, proj:'lcc'},$
	   
	   CO4    :{lon0: -97d   ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-1004000d  ,y0: -260000d  ,dx:  4000d,dy:  4000d,nx: 149L,ny: 131L,r: 6370000d, proj:'lcc'},$
	   	   	   
           T36    :{lon0:-97d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-2736000d  ,y0:-2088000d  ,dx: 36000d,dy: 36000d,nx: 148L,ny: 112L,r: 6370000d, proj:'lcc'},$ 
           TCNA36 :{lon0:-97d    ,lat0:40d   ,lat1:30d ,lat2:45d ,x0:-2916000d  ,y0:-2304000d  ,dx: 36000d,dy: 36000d,nx: 162L,ny: 128L,r: 6370000d, proj:'lcc'},$ 
           TCSUS12:{lon0:-97d    ,lat0:40d   ,lat1:30d ,lat2:45d ,x0:-1188000d  ,y0:-1800000d  ,dx: 12000d,dy: 12000d,nx: 174L,ny: 138L,r: 6370000d, proj:'lcc'},$ 
           TCTX04 :{lon0:-97d    ,lat0:40d   ,lat1:30d ,lat2:45d ,x0: -408000d  ,y0:-1632000d  ,dx:  4000d,dy:  4000d,nx: 216L,ny: 288L,r: 6370000d, proj:'lcc'},$ 	   	   	   

	   K12    :{lon0:120d    ,lat0:40d   ,lat1:33d ,lat2:45d ,x0:-4308000d  ,y0:-4656000d  ,dx: 12000d,dy: 12000d,nx: 718L,ny:776L, r: 6370000d, proj:'lcc'},$	   
	   K03    :{lon0:126d    ,lat0:38d   ,lat1:30d ,lat2:60d ,x0:       0d  ,y0: -135000d  ,dx:  3000d,dy:  3000d,nx:  58L,ny: 61L, r: 6370000d, proj:'lcc'},$	   
	   K09    :{lon0:126d    ,lat0:38d   ,lat1:30d ,lat2:60d ,x0: -180000d  ,y0: -585000d  ,dx:  9000d,dy:  9000d,nx:  67L,ny: 82L, r: 6370000d, proj:'lcc'},$	   
	   K27    :{lon0:126d    ,lat0:38d   ,lat1:30d ,lat2:60d ,x0:-2349000d  ,y0:-1728000d  ,dx: 27000d,dy: 27000d,nx: 174L,ny:128L, r: 6370000d, proj:'lcc'},$	   
	   	   	   	   
	   CA4B   :{lon0:-106d   ,lat0:54d   ,                    x0:-15.7080d  ,y0:-21.7260d  ,dx: 0.042d,dy: 0.036d,nx: 241L,ny:346L,	             proj:'rll'},$
           NAMB   :{lon0:-106d   ,lat0:54d   ,                    x0: -60.102d  ,y0:- 45.090d  ,dx: 0.126d,dy: 0.108d,nx: 954L,ny:835L,	             proj:'rll'},$
           B04    :{lon0:-106d   ,lat0:54d   ,                    x0:-16.695046d,y0:-29.375995d,dx: 0.042d,dy: 0.036d,nx:1114L,ny:880L,		     proj:'rll'},$
           B3X    :{lon0:-106d   ,lat0:54d   ,                    x0:   8.048d  ,y0: -20.955d  ,dx: 0.126d,dy: 0.108d,nx: 180L,ny:144L,              proj:'rll'},$
	   
	   ;AQUM   :{lon0:306.97d ,lat0:52.43d,x0:330.3d,y0:-23.76d,dx:0.11d,dy:0.11d,nx:540L,ny:432L,r:6371229d,proj:'ell'},$
	   AQUM   :{lon0:306.97d ,lat0:52.43d,x0:-29.7d,y0:-23.76d,dx:0.11d,dy:0.11d,nx:540L,ny:432L,r:6371229d,proj:'ell'},$
			   
	   WORLD  :{x0:-179.5d, y0:-80d, dx:1d, dy:1d, nx:360L, ny:160L,proj:'ll'},$
	   GLOBAL :{x0:  -180d, y0:-90d, dx:1d, dy:1d, nx:360L, ny:180L,proj:'ll'},$
	   G1     :{x0:  -180d, y0:-90d, dx:1d, dy:1d, nx:360L, ny:180L,proj:'ll'},$
	   G01    :{x0:  -180d, y0:-90d, dx:0.1d, dy:0.1d, nx:3600L, ny:1800L,proj:'ll'},$	
	   G05    :{x0:  -180d, y0:-90d, dx:0.5d, dy:0.5d, nx:720L, ny:360L,proj:'ll'},$		      
	   AFR    :{x0:  -100d, y0:  0d, dx:1d, dy:1d, nx:101L, ny: 41L,proj:'ll'},$
	   CESM   :{x0: -1.25d, y0:-89.052632d,dx:2.5d,dy:1.8947368d,nx:144L,ny:94L,proj:'ll'}}
	   
	   ;
	   
;if file_test('minfo.add') then begin
;	@minfo.add
;	if var_set(add) then domains = struct_merge(domains,add)
;endif
	   
  ; read initial info					 
			  
case 1 of

	keyword_set(_file) : begin
	
		gatt = ['XCENT','YCENT','P_ALP','P_BET','XORIG','YORIG','XCELL','YCELL','NCOLS','NROWS']
		if ~ncdf_info(_file[0],/check,gatt=gatt) then message,str(/join,'NOT PROPER NCDF:',gatt)
	
		cdf_id = ncdf_open(_file[0])

		ncdf_attget,cdf_id,/global,'XCENT',xcent
		ncdf_attget,cdf_id,/global,'YCENT',ycent
		ncdf_attget,cdf_id,/global,'P_ALP',p_alp
		ncdf_attget,cdf_id,/global,'P_BET',p_bet    
		ncdf_attget,cdf_id,/global,'XORIG',xorig
		ncdf_attget,cdf_id,/global,'YORIG',yorig
		ncdf_attget,cdf_id,/global,'XCELL',xcell
		ncdf_attget,cdf_id,/global,'YCELL',ycell
		ncdf_attget,cdf_id,/global,'NCOLS',ncols
		ncdf_attget,cdf_id,/global,'NROWS',nrows
    		  
		ncdf_close,cdf_id		    
		
		minfo = {lon0:xcent,lat0:ycent,lat1:p_alp,lat2:p_bet,x0:xorig,y0:yorig,dx:xcell,dy:ycell,nx:ncols,ny:nrows}
												
		end
	
	var_set(_minfo) : minfo = _minfo
		
	var_set(_domain) : minfo = struct(/read,domains,(str(strmid(str(_domain),0,1),/is_number) ? '_' : '' )+str(/up,_domain))
				
	else : message,'OPTIONS (/FILE,/DOMAIN,/MINFO)'

endcase

	; update minfo
	; determine possible map projection
	; use r=6370000 if not specified
	
if ~struct(/set,minfo,'r') then minfo = struct(/merge,minfo,{r:6370000.})

if ~struct(/set,minfo,'proj') then begin

	case 1 of
		
		minfo.lat1 eq 0 and minfo.lat2 eq 0 : minfo = struct(/merge,minfo,{proj:'rll'})
		else : minfo = struct(/merge,minfo,{proj:'lcc'})
	
	endcase

endif
	
if var_set(radius) then minfo = struct(/merge,minfo,{r:radius})
if var_set(proj)   then minfo = struct(/merge,minfo,{proj:proj})

	; zoom in (zoom=[x0,y0,x1,y2])
	
if var_set(zoom) then minfo = struct(/merge,minfo,{nx:long(zoom[2]-zoom[0]+1),ny:long(zoom[3]-zoom[1])+1,x0:minfo.x0+minfo.dx*zoom[0],y0:minfo.y0+minfo.dy*zoom[1]})

	; return

omid = aqm_grid_mid(minfo)
onx  = minfo.nx
ony  = minfo.ny
	
return,minfo	

end
