;-------------------------------------------------------------------------------
;	NAME
;		aqm_grid_mid
;
;	PURPOSE
;		generate map ID / check if two minfos are same
;
;	USAGE
;		mid = aqm_grid_mid(minfo[,minfo2,/check])
;
;	INPUT
;		minfo : map information (see aqm_grid.pro)
;
;	KEYWORD
;		check : check two minfos are same
;
;	AUTHOR
;		2009-10-23 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2009-12-16 added rll
;-------------------------------------------------------------------------------

	function aqm_grid_mid,_minfo1,_minfo2,check=check
	
;-------------------------------------------------------------------------------	

if var_set(_minfo1) then minfo1 = minfo(_minfo1)
if var_set(_minfo2) then minfo2 = minfo(_minfo2)

;if var_set(_minfo1) then minfo1 = aqm_grid_minfo(minfo=_minfo1)
;if var_set(_minfo2) then minfo2 = aqm_grid_minfo(minfo=_minfo2)


case 1 of

	Keyword_set(check) : begin
	
		case str(/low,minfo1.proj) of
		
			'lcc' : allow = 0.1
			'rll' : allow = 0.001
		
		endcase
					
		if struct(/set,minfo1,'lon0') then if minfo1.lon0-minfo2.lon0 gt allow then return,0B
		if struct(/set,minfo1,'lat0') then if minfo1.lat0-minfo2.lat0 gt allow then return,0B
		if struct(/set,minfo1,'lat1') then if minfo1.lat1-minfo2.lat1 gt allow then return,0B
		if struct(/set,minfo1,'lat2') then if minfo1.lat2-minfo2.lat2 gt allow then return,0B
		if struct(/set,minfo1,'x0')   then if minfo1.x0-minfo2.x0     gt allow then return,0B
		if struct(/set,minfo1,'y0')   then if minfo1.y0-minfo2.y0     gt allow then return,0B     
		if struct(/set,minfo1,'dx')   then if minfo1.dx-minfo2.dx     gt allow then return,0B
		if struct(/set,minfo1,'dy')   then if minfo1.dy-minfo2.dy     gt allow then return,0B		    
		if struct(/set,minfo1,'nx')   then if minfo1.nx ne minfo2.nx           then return,0B
		if struct(/set,minfo1,'ny')   then if minfo1.ny ne minfo2.ny           then return,0B
		
		return,1B
		
		end
		
	else : begin
	
		case str(/low,minfo1.proj) of
		
			'lcc' : return,str(abs(long(total([minfo1.lon0,minfo1.lat0,minfo1.lat1,minfo1.lat2,minfo1.x0,minfo1.y0,minfo1.nx,minfo1.ny,minfo1.dx,minfo1.dy]))))+'_'+str(long(minfo1.nx))+'x'+str(long(minfo1.ny))+'k'+str(fix(minfo1.dx/1000))
			'rll' : return,str(abs(long(total([minfo1.lon0,minfo1.lat0,minfo1.x0,minfo1.y0,minfo1.nx,minfo1.ny,minfo1.dx,minfo1.dy]*1000))))+'_'+str(long(minfo1.nx))+'x'+str(long(minfo1.ny))+'d'+str(fix(minfo1.dx*1000))
			'ell' : return,str(abs(long(total([minfo1.lon0,minfo1.lat0,minfo1.x0,minfo1.y0,minfo1.nx,minfo1.ny,minfo1.dx,minfo1.dy]*1000))))+'_'+str(long(minfo1.nx))+'x'+str(long(minfo1.ny))+'d'+str(fix(minfo1.dx*1000))
			'll' : return,str(abs(long(total([minfo1.x0,minfo1.y0,minfo1.nx,minfo1.ny,minfo1.dx,minfo1.dy]*1000))))+'_'+str(long(minfo1.nx))+'x'+str(long(minfo1.ny))+'l'+str(fix(minfo1.dx*1000))
									
		endcase
	
		end		

endcase

end
