;-------------------------------------------------------------------------------
;	NAME
;		aqm_grid_limit
;
;	PURPOSE
;		to return outer boundary limit for given domain setting
;
;	USAGE
;		r = aqm_grid_limit
;
;	INPUT
;		data   : domain/minfo
;		domain : domain nickname
;		minfo  : map information
;		file   : m3 data file 
;
;	KEYWORD
;		map_set : return 8-element limit array for map_set
;		range   : return 4-element limit with maximum range
;
;	AUTHOR
;		2012-05-30 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------

	function aqm_grid_limit,data,domain=domain,minfo=minfo,file=file,map_set=map_set,range=range
	
;-------------------------------------------------------------------------------

if struct(/set,data) then minfo = data
if var_set(data) then if size(data,/type) eq 7 then domain = data

minfo = aqm_grid_minfo(domain=domain,minfo=minfo,file=file)

case 1 of

	keyword_set(map_set) : begin
	
		lx = [minfo.x0-minfo.dx/2d,minfo.x0-minfo.dx/2d + minfo.dx*minfo.nx]
		ly = [minfo.y0-minfo.dy/2d,minfo.y0-minfo.dy/2d + minfo.dy*minfo.ny]
		
		rr = aqm_proj(lx[[0,1,1,0]],ly[[0,0,1,1]],/lcc,/to_ll,minfo=minfo)					
		rr = rr[[1,0,7,6,5,4,3,2]]

		return,rr		
	
		end
		
	else : begin		

		lx = indgen(minfo.nx+1)*minfo.dx+minfo.x0-minfo.dx/2d
		ly = indgen(minfo.ny+1)*minfo.dy+minfo.y0-minfo.dy/2d
		lx = [lx,replicate(max(lx),minfo.ny+1),reverse(lx),replicate(min(lx),minfo.ny+1)]
		ly = [replicate(min(ly),minfo.nx+1),ly,replicate(max(ly),minfo.nx+1),reverse(ly)]
				
		case struct_read(minfo,'proj') of 
		
			'lcc' : rr = aqm_proj(lx,ly,/lcc,/to_ll,minfo=minfo)
			'ell' : rr = aqm_proj(lx,ly,/ell,/to_ll,minfo=minfo)			
			'll'  : rr = transpose([[lx],[ly]])
		
		endcase
				
		end
		
endcase

if keyword_set(range) then rr = [min(rr[0,*]),min(rr[1,*]),max(rr[0,*]),max(rr[1,*])]

return,rr

end
