;-------------------------------------------------------------------------------	
;	NAME
;		aqm_gi
;
;	PURPOSE
;		simplified version of aqm_grid_index
;
;	AUTHOR
;		2011-05-10 Hyun Cheol Kim (hyun.kim@noaa.gov)
;		2012-07-13 added 'll'
;		2015-08-13 added 'ell'
;-------------------------------------------------------------------------------	

	function aqm_gi,_lon,_lat,domain=domain,minfo=minfo,map_structure=ms,line=line,track=track,olen=olen,raw=raw
	
;-------------------------------------------------------------------------------	

lon   = [_lon]
lat   = [_lat]
minfo = aqm_grid(domain=domain,minfo=minfo)
dim   = size(lon,/dim)

case str(/low,minfo.proj) of

	'lcc' : out = map_proj_forward(lon,lat,map_structure=var_set(ms) ? ms : map_proj_init(3,sphere_radius=minfo.r,standard_par1=minfo.lat1,standard_par2=minfo.lat2,center_longitude=minfo.lon0,center_latitude=minfo.lat0))
	'rll' : out = transpose([[ary((atan(cos(lat*!dtor)*sin(lon*!dtor-minfo.lon0*!dtor),cos(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)+sin(minfo.lat0*!dtor)*sin(lat*!dtor)))/!dtor,/flat)],[ary((asin(cos(minfo.lat0*!dtor)*sin(lat*!dtor)-sin(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)))/!dtor,/flat)]])
	'ell' : out = transpose([[ary((atan(cos(lat*!dtor)*sin(lon*!dtor-minfo.lon0*!dtor),cos(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)+sin(minfo.lat0*!dtor)*sin(lat*!dtor)))/!dtor,/flat)],[ary((asin(cos(minfo.lat0*!dtor)*sin(lat*!dtor)-sin(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)))/!dtor,/flat)]])
	'll'  : out = transpose([[ary(/flat,temporary(lon))],[ary(/flat,temporary(lat))]])

endcase

case 1 of

	keyword_set(track) : return,linetrack((out[0,*]-minfo.x0)/minfo.dx,(out[1,*]-minfo.y0)/minfo.dy,dim=[minfo.nx,minfo.ny],olen=olen)	
	keyword_set(line)  : return,lineclip((out[0,*]-minfo.x0)/minfo.dx,(out[1,*]-minfo.y0)/minfo.dy,dim=[minfo.nx,minfo.ny])
	
	else : begin
	
		ix  = round((out[0,*]-minfo.x0-minfo.dx/2d)/minfo.dx)
		if ~keyword_set(raw) then ix  = data_check(ix,ix lt 0 or ix gt minfo.nx-1,-1)
		iy  = round((out[1,*]-minfo.y0-minfo.dy/2d)/minfo.dy)
		if ~keyword_set(raw) then iy  = data_check(iy,iy lt 0 or iy gt minfo.ny-1,-1)
		ixy = data_check(ix+iy*minfo.nx,ix lt 0 or ix gt minfo.nx-1 or iy lt 0 or iy gt minfo.ny-1,-1)
		
		return,{ix:reform(ix,dim),iy:reform(iy,dim),ixy:reform(ixy,dim)}
		end
endcase
		
end
