;-------------------------------------------------------------------------------
;	NAME
;		aqm_fgi
;
;	PURPOSE
;		Calculate fractional grid index
;
;	USAGE	
;		aqm_fgi,lon,lat,x,y,minfo[,map_structure=map_structre]
;
;	INPUT
;		lon/lat : longitude/latitude
;		map_structure : map_structure strucutre for map projection conversion
;
;	OUTPUT
;		x/y : fractional grid index
;
;	AUTHOR
;		2012-09-17 Hyun Cheol Kim (hyun.kim@noaa.gov)
;-------------------------------------------------------------------------------	

	pro aqm_fgi,lon,lat,x,y,domain=domain,minfo=minfo,map_structure=ms,center=center
	
;-------------------------------------------------------------------------------	

if ~var_set(minfo) then minfo = aqm_grid_minfo(domain=domain,minfo=minfo)
dim   = size(lon,/dim)
ndim  = size(lon,/n_dim)

case str(/low,minfo.proj) of

	'lcc' : out = map_proj_forward(lon,lat,map_structure=(ms = var_set(ms) ? ms : map_proj_init(3,sphere_radius=minfo.r,standard_par1=minfo.lat1,standard_par2=minfo.lat2,center_longitude=minfo.lon0,center_latitude=minfo.lat0)))
	'rll' : out = transpose([[ary((atan(cos(lat*!dtor)*sin(lon*!dtor-minfo.lon0*!dtor),cos(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)+sin(minfo.lat0*!dtor)*sin(lat*!dtor)))/!dtor,/flat)],[array((asin(cos(minfo.lat0*!dtor)*sin(lat*!dtor)-sin(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)))/!dtor,/flat)]])
	'ell' : out = transpose([[ary((atan(cos(lat*!dtor)*sin(lon*!dtor-minfo.lon0*!dtor),cos(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)+sin(minfo.lat0*!dtor)*sin(lat*!dtor)))/!dtor,/flat)],[array((asin(cos(minfo.lat0*!dtor)*sin(lat*!dtor)-sin(minfo.lat0*!dtor)*cos(lat*!dtor)*cos(lon*!dtor-minfo.lon0*!dtor)))/!dtor,/flat)]])
	'll'  : out = transpose([[ary(/flat,lon)],[array(/flat,lat)]])

endcase

x  = ndim gt 0 ? reform((out[0,*]-minfo.x0)/minfo.dx,size(lon,/dim),/overwrite) : ((out[0,*]-minfo.x0)/minfo.dx)[0]
y  = ndim gt 0 ? reform((out[1,*]-minfo.y0)/minfo.dy,size(lat,/dim),/overwrite) : ((out[1,*]-minfo.y0)/minfo.dy)[0]

if keyword_set(center) then x -= 0.5
if keyword_set(center) then y -= 0.5

end
