function [s] = f02_compounds()
    s(1).name    = 'Maltotriose';
    s(1).file    = 'maltotriose.txt';
    s(1).kobs    = [3e-2 7e-2];
    s(1).sol     = 1;
    s(1).MW_obs  = 504.4;
    s(1).rho_obs = -999;
    s(1).Cx      = 18;
    s(1).Hx      = 32;
    s(1).Ox      = 16;
    s(1).Nx      = 0;
    s(1).D       = 80;

    s(2).name    = 'Sucrose';
    s(2).file    = 'sucrose.txt';
    s(2).kobs    = [0.07 0.11];
    s(2).sol     = 1.3e0;
    s(2).MW_obs  = 342.3;
    s(2).rho_obs = 1.589;
    s(2).Cx      = 12;
    s(2).Hx      = 22;
    s(2).Ox      = 11;
    s(2).Nx      = 0;
    s(2).D       = 80;

    s(3).name    = 'Glucose';
    s(3).file    = 'glucose.txt';
    s(3).kobs    = [1.4e-1 2.0e-1];
    s(3).sol     = 5.8e-1;
    s(3).MW_obs  = 180.2;
    s(3).rho_obs = 1.556;
    s(3).Cx      = 6;
    s(3).Hx      = 12;
    s(3).Ox      = 6;
    s(3).Nx      = 0;
    s(3).D       = 80;

    s(4).name    = 'Threitol';
    s(4).file    = 'threitol.txt';
    s(4).kobs    = [0.12 0.16];
    s(4).sol     = 4.4e-1;
    s(4).MW_obs  = 122;
    s(4).rho_obs = 1.451;
    s(4).Cx      = 4;
    s(4).Hx      = 10;
    s(4).Ox      = 4;
    s(4).Nx      = 0;
    s(4).D       = 80;

    s(5).name    = 'Threitol';
    s(5).file    = 'threitol.txt';
    s(5).kobs    = [0.12 0.16];
    s(5).sol     = 4.4e-1;
    s(5).MW_obs  = 122;
    s(5).rho_obs = 1.451;
    s(5).Cx      = 4;
    s(5).Hx      = 10;
    s(5).Ox      = 4;
    s(5).Nx      = 0;
    s(5).D       = 80;

    s(6).name    = 'Stearic Acid';
    s(6).file    = 'stearic acid.txt';
    s(6).kobs    = [2e-5];
    s(6).sol     = 3.5e-5;
    s(6).MW_obs  = 284.5;
    s(6).rho_obs = 0.8470;
    s(6).Cx      = 18;
    s(6).Hx      = 36;
    s(6).Ox      = 2;
    s(6).Nx      = 0;
    s(6).D       = 200;
    
    s(7).name    = 'Palmitic Acid';
    s(7).file    = 'palmitic acid.txt';
    s(7).kobs    = [2e-5];
    s(7).sol     = 2.3e-5;
    s(7).MW_obs  = 256.4;
    s(7).rho_obs = 0.8530;
    s(7).Cx      = 16;
    s(7).Hx      = 32;
    s(7).Ox      = 2;
    s(7).Nx      = 0;
    s(7).D       = 200;

    s(8).name    = 'Myristic Acid';
    s(8).file    = 'myristic acid.txt';
    s(8).kobs    = [2e-5];
    s(8).sol     = 2.3e-5;
    s(8).MW_obs  = 228.4;
    s(8).rho_obs = 0.8660;
    s(8).Cx      = 14;
    s(8).Hx      = 28;
    s(8).Ox      = 2;
    s(8).Nx      = 0;
    s(8).D       = 200;

    s(9).name    = 'Cetyl Alcohol';
    s(9).file    = 'cetyl alcohol.txt';
    s(9).kobs    = [2e-5];
    s(9).sol     = 1.2e-9;
    s(9).MW_obs  = 242.5;
    s(9).rho_obs = 0.8300;
    s(9).Cx      = 16;
    s(9).Hx      = 34;
    s(9).Ox      = 1;
    s(9).Nx      = 0;
    s(9).D       = 200;
    
    s(10).name    = 'Oleic Acid';
    s(10).file    = 'oleic acid.txt';
    s(10).kobs    = [1e-5];
    s(10).sol     = 1e-9;
    s(10).MW_obs  = 282.5;
    s(10).rho_obs = 0.8900;
    s(10).Cx      = 18;
    s(10).Hx      = 34;
    s(10).Ox      = 2;
    s(10).Nx      = 0;
    s(10).D       = 350;

    s(11).name    = 'Peroxide Ether';
    s(11).file    = 'peroxide ether.txt';
    s(11).kobs    = [2.5e-3 4.9e-3];
    s(11).sol     = -999;
    s(11).MW_obs  = -999;
    s(11).rho_obs = -999;
    s(11).Cx      = 14;
    s(11).Hx      = 30;
    s(11).Ox      = 3;
    s(11).Nx      = 0;
    s(11).D       = 205;
    
    s(12).name    = 'Peroxide Ether w/ Aldehyde';
    s(12).file    = 'peroxide ether aldehyde.txt';
    s(12).kobs    = [9.2e-4];
    s(12).sol     = -999;
    s(12).MW_obs  = -999;
    s(12).rho_obs = -999;
    s(12).Cx      = 14;
    s(12).Hx      = 28;
    s(12).Ox      = 4;
    s(12).Nx      = 0;
    s(12).D       = 264;

    s(13).name    = 'Peroxide Ether w/ Acid';
    s(13).file    = 'peroxide ether acid.txt';
    s(13).kobs    = [1.3e-2 2.8e-2];
    s(13).sol     = -999;
    s(13).MW_obs  = -999;
    s(13).rho_obs = -999;
    s(13).Cx      = 14;
    s(13).Hx      = 28;
    s(13).Ox      = 5;
    s(13).Nx      = 0;
    s(13).D       = 123;

    s(14).name    = 'Diperoxide Diether';
    s(14).file    = 'diperoxide diether.txt';
    s(14).kobs    = [1.0e-2 2.8e-2];
    s(14).sol     = -999;
    s(14).MW_obs  = -999;
    s(14).rho_obs = -999;
    s(14).Cx      = 14;
    s(14).Hx      = 30;
    s(14).Ox      = 6;
    s(14).Nx      = 0;
    s(14).D       = 205;

    s(15).name    = 'C10 Dihydroxynitrate';
    s(15).file    = 'C10dihydroxynitrate.txt';
    s(15).kobs    = [9.8e-2];
    s(15).sol     = -999;
    s(15).MW_obs  = -999;
    s(15).rho_obs = -999;
    s(15).Cx      = 10;
    s(15).Hx      = 21;
    s(15).Ox      = 5;
    s(15).Nx      = 1;    
    s(15).D       = 100;

    s(16).name    = 'C10 Trihydroxynitrate';
    s(16).file    = 'C10trihydroxynitrate.txt';
    s(16).kobs    = [1.5e-1];
    s(16).sol     = -999;
    s(16).MW_obs  = -999;
    s(16).rho_obs = -999;
    s(16).Cx      = 10;
    s(16).Hx      = 21;
    s(16).Ox      = 6;
    s(16).Nx      = 1;    
    s(16).D       = 88;

    s(17).name    = 'C11 Dihydroxynitrate';
    s(17).file    = 'C11dihydroxynitrate.txt';
    s(17).kobs    = [2.4e-2];
    s(17).sol     = -999;
    s(17).MW_obs  = -999;
    s(17).rho_obs = -999;
    s(17).Cx      = 11;
    s(17).Hx      = 23;
    s(17).Ox      = 5;
    s(17).Nx      = 1;    
    s(17).D       = 100;

    s(18).name    = 'C11 Trihydroxynitrate';
    s(18).file    = 'C11trihydroxynitrate.txt';
    s(18).kobs    = [1.7e-1];
    s(18).sol     = -999;
    s(18).MW_obs  = -999;
    s(18).rho_obs = -999;
    s(18).Cx      = 11;
    s(18).Hx      = 23;
    s(18).Ox      = 6;
    s(18).Nx      = 1;    
    s(18).D       = 88;

    s(19).name    = 'C12 Dihydroxynitrate';
    s(19).file    = 'C12dihydroxynitrate.txt';
    s(19).kobs    = [1.8e-2];
    s(19).sol     = -999;
    s(19).MW_obs  = -999;
    s(19).rho_obs = -999;
    s(19).Cx      = 12;
    s(19).Hx      = 25;
    s(19).Ox      = 5;
    s(19).Nx      = 1;    
    s(19).D       = 222;
       
    s(20).name    = 'C12 Trihydroxynitrate';
    s(20).file    = 'C12trihydroxynitrate.txt';
    s(20).kobs    = [1.8e-1];
    s(20).sol     = -999;
    s(20).MW_obs  = -999;
    s(20).rho_obs = -999;
    s(20).Cx      = 12;
    s(20).Hx      = 25;
    s(20).Ox      = 6;
    s(20).Nx      = 1;    
    s(20).D       = 100;
    
    s(21).name    = 'C13 hydroxynitrate';
    s(21).file    = 'C13hydroxynitrate.txt';
    s(21).kobs    = [4.5e-3];
    s(21).sol     = -999;
    s(21).MW_obs  = -999;
    s(21).rho_obs = -999;
    s(21).Cx      = 13;
    s(21).Hx      = 27;
    s(21).Ox      = 4;
    s(21).Nx      = 1;    
    s(21).D       = 302;

    s(22).name    = 'C13 dihydroxynitrate';
    s(22).file    = 'C13dihydroxynitrate.txt';
    s(22).kobs    = [2.7e-3];
    s(22).sol     = -999;
    s(22).MW_obs  = -999;
    s(22).rho_obs = -999;
    s(22).Cx      = 13;
    s(22).Hx      = 27;
    s(22).Ox      = 5;
    s(22).Nx      = 1;    
    s(22).D       = 222;

    s(23).name    = 'C13 trihydroxynitrate';
    s(23).file    = 'C13trihydroxynitrate.txt';
    s(23).kobs    = [2.8e-2];
    s(23).sol     = -999;
    s(23).MW_obs  = -999;
    s(23).rho_obs = -999;
    s(23).Cx      = 13;
    s(23).Hx      = 27;
    s(23).Ox      = 6;
    s(23).Nx      = 1;    
    s(23).D       = 111;

    s(24).name    = 'C14 hydroxynitrate';
    s(24).file    = 'C14hydroxynitrate.txt';
    s(24).kobs    = [4.8e-5];
    s(24).sol     = -999;
    s(24).MW_obs  = -999;
    s(24).rho_obs = -999;
    s(24).Cx      = 14;
    s(24).Hx      = 29;
    s(24).Ox      = 4;
    s(24).Nx      = 1;    
    s(24).D       = 302;

    s(25).name    = 'C14 dihydroxynitrate';
    s(25).file    = 'C14dihydroxynitrate.txt';
    s(25).kobs    = [2.6e-2];
    s(25).sol     = -999;
    s(25).MW_obs  = -999;
    s(25).rho_obs = -999;
    s(25).Cx      = 14;
    s(25).Hx      = 29;
    s(25).Ox      = 5;
    s(25).Nx      = 1;    
    s(25).D       = 222;

    s(26).name    = 'C14 trihydroxynitrate';
    s(26).file    = 'C14trihydroxynitrate.txt';
    s(26).kobs    = [1.0e-1];
    s(26).sol     = -999;
    s(26).MW_obs  = -999;
    s(26).rho_obs = -999;
    s(26).Cx      = 14;
    s(26).Hx      = 29;
    s(26).Ox      = 6;
    s(26).Nx      = 1;    
    s(26).D       = 111;

    s(27).name    = 'C15 hydroxynitrate';
    s(27).file    = 'C15hydroxynitrate.txt';
    s(27).kobs    = [8.8e-4];
    s(27).sol     = -999;
    s(27).MW_obs  = -999;
    s(27).rho_obs = -999;
    s(27).Cx      = 15;
    s(27).Hx      = 31;
    s(27).Ox      = 4;
    s(27).Nx      = 1;    
    s(27).D       = 302;

    s(28).name    = 'C15 dihydroxynitrate';
    s(28).file    = 'C15dihydroxynitrate.txt';
    s(28).kobs    = [2.2e-2];
    s(28).sol     = -999;
    s(28).MW_obs  = -999;
    s(28).rho_obs = -999;
    s(28).Cx      = 15;
    s(28).Hx      = 31;
    s(28).Ox      = 5;
    s(28).Nx      = 1;    
    s(28).D       = 223;

    s(29).name    = 'C15 trihydroxynitrate';
    s(29).file    = 'C15trihydroxynitrate.txt';
    s(29).kobs    = [8.1e-2];
    s(29).sol     = -999;
    s(29).MW_obs  = -999;
    s(29).rho_obs = -999;
    s(29).Cx      = 15;
    s(29).Hx      = 31;
    s(29).Ox      = 6;
    s(29).Nx      = 1;    
    s(29).D       = 111;

    s(30).name    = 'C14 dinitrate';
    s(30).file    = 'C14dinitrate.txt';
    s(30).kobs    = [3.6e-3];
    s(30).sol     = -999;
    s(30).MW_obs  = -999;
    s(30).rho_obs = -999;
    s(30).Cx      = 14;
    s(30).Hx      = 28;
    s(30).Ox      = 6;
    s(30).Nx      = 2;    
    s(30).D       = 220;

    s(31).name    = 'C14 trinitrate';
    s(31).file    = 'C14trinitrate.txt';
    s(31).kobs    = [2.9e-4];
    s(31).sol     = -999;
    s(31).MW_obs  = -999;
    s(31).rho_obs = -999;
    s(31).Cx      = 14;
    s(31).Hx      = 27;
    s(31).Ox      = 9;
    s(31).Nx      = 3;    
    s(31).D       = 332;

    s(32).name    = 'C14 tetranitrate';
    s(32).file    = 'C14tetranitrate.txt';
    s(32).kobs    = [1.2e-3];
    s(32).sol     = -999;
    s(32).MW_obs  = -999;
    s(32).rho_obs = -999;
    s(32).Cx      = 14;
    s(32).Hx      = 26;
    s(32).Ox      = 12;
    s(32).Nx      = 4;    
    s(32).D       = 332;

    s(33).name    = 'Cis-pinonic acid';
    s(33).file    = 'cis pinonic acid.txt';
    s(33).kobs    = [9e-3 4e-2];
    s(33).sol     = 5.5e-3;
    s(33).MW_obs  = 184.2;
    s(33).rho_obs = 1.169;
    s(33).Cx      = 10;
    s(33).Hx      = 16;
    s(33).Ox      = 3;
    s(33).Nx      = 0;
    s(33).D       = 165;
        
    s(34).name    = 'Azelaic Acid';
    s(34).file    = 'azelaic acid.txt';
    s(34).kobs    = [2e-2 4e-2];
    s(34).sol     = 4e-3;
    s(34).MW_obs  = 188.2;
    s(34).rho_obs = 1.251;
    s(34).Cx      = 9;
    s(34).Hx      = 16;
    s(34).Ox      = 4;
    s(34).Nx      = 0;
    s(34).D       = 113;
    
    s(35).name    = 'Pimelic Acid';
    s(35).file    = 'pimelic acid.txt';
    s(35).kobs    = [1.4e-1 1.6e-1];
    s(35).sol     = 5.1e-2;
    s(35).MW_obs  = 160.2;
    s(35).rho_obs = 1.321;
    s(35).Cx      = 7;
    s(35).Hx      = 12;
    s(35).Ox      = 4;
    s(35).Nx      = 0;
    s(35).D       = 300;
   
    s(36).name    = 'Adipic Acid';
    s(36).file    = 'adipic acid.txt';
    s(36).kobs    = [0.001 0.01];
    s(36).sol     = 1.8e-2;
    s(36).MW_obs  = 146.2;
    s(36).rho_obs = 1.352;
    s(36).Cx      = 6;
    s(36).Hx      = 10;
    s(36).Ox      = 4;
    s(36).Nx      = 0;
    s(36).D       = 200;

    s(37).name    = 'Glutaric Acid';
    s(37).file    = 'glutaric acid.txt';
    s(37).kobs    = [0.054 0.158];
    s(37).sol     = 8.1e-1;
    s(37).MW_obs  = 132.1;
    s(37).rho_obs = 1.429;
    s(37).Cx      = 5;
    s(37).Hx      = 8;
    s(37).Ox      = 4;
    s(37).Nx      = 0;
    s(37).D       = 300;

    s(38).name    = 'Ketoglutaric Acid';
    s(38).file    = 'ketoglutaric acid.txt';
    s(38).kobs    = [0.27 0.35];
    s(38).sol     = 1;
    s(38).MW_obs  = 146.11;
    s(38).rho_obs = 1.499;
    s(38).Cx      = 5;
    s(38).Hx      = 6;
    s(38).Ox      = 5;
    s(38).Nx      = 0;
    s(38).D       = 300;

    s(39).name    = 'Succinic Acid';
    s(39).file    = 'succinic acid.txt';
    s(39).kobs    = [0.17 0.30];
    s(39).sol     = 5.7e-2;
    s(39).MW_obs  = 118.1;
    s(39).rho_obs = 1.552;
    s(39).Cx      = 4;
    s(39).Hx      = 6;
    s(39).Ox      = 4;
    s(39).Nx      = 0;
    s(39).D       = 300;

    s(40).name    = 'Maleic Acid';
    s(40).file    = 'maleic acid.txt';
    s(40).kobs    = [0.17 0.30];
    s(40).sol     = 9.1e-1;
    s(40).MW_obs  = 116.072;
    s(40).rho_obs = 1.63;
    s(40).Cx      = 4;
    s(40).Hx      = 4;
    s(40).Ox      = 4;
    s(40).Nx      = 0;
    s(40).D       = 300;
end

