# ******************************************************
## Revision "$LastChangedDate: 2013-11-24 21:34:41 +0100 (Sun, 24 Nov 2013) $"
## Date "$LastChangedRevision: 410 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/hydraulic_load.py $"
# ******************************************************

import os
import ascraster

def calculate(params,mask,residence_time_grid,lake_icell_dict):
    '''
    This function calculates the hydraulic load in the water bodies.
    '''

    # Depth water of waterbody in metres (result of residence time function)
    depth_grid = ascraster.Asciigrid(ascii_file=os.path.join(params.outputdir,"depth_waterbody_grid.asc"),\
                                              mask=mask,numtype=float)   

    hydraulic_load_grid = ascraster.duplicategrid(residence_time_grid)
    hydraulic_load_grid.add_values(hydraulic_load_grid.length *[0.0])
    for icell in range(hydraulic_load_grid.length):
        depth = depth_grid.get_data(icell,0.0)
        resi_time = residence_time_grid.get_data(icell,0.0)
        try:
            Hl = depth/resi_time
        except ZeroDivisionError:
            Hl = 0.0
        hydraulic_load_grid.set_data(icell,Hl)

    # Write hydraulic load to output file:
    hydraulic_load_grid.write_ascii_file(os.path.join(params.outputdir,"hydraulic_load.asc"))

    return hydraulic_load_grid
