# ******************************************************
## Revision "$LastChangedDate: 2014-10-17 09:52:06 +0200 (Fri, 17 Oct 2014) $"
## Date "$LastChangedRevision: 466 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/error.py $"
# ******************************************************
## ---------------------------------------------------------------------------
## -
## -    Name:    error.py
## -    Author:  Arthur Beusen en Martine de Vos PBL/IMP
## -    Adjusted:Allard Warrink PBL/IMP
## -    Date:    June 18 2008
## -    Purpose: Error handling of exceptions
## -
## ---------------------------------------------------------------------------

class MyError(Exception):
    """
    Stores an exception on type or format of arguments from the commandline. 
    This class is used to generate a message to standard output.
    This message can contain multiple lines.
    Inherits properties from build in class Exception.
    """
    def __init__(self, *args):
        """ Initialisation of class MyError."""
        self.args = args
    
    def __str__(self):
        """ Returns a formatted version of the objects content. """
        return repr(''.join(map(str, self.args)))
    
    def write(self):
        """ Writes an error message to standard output. """
        print "***** ERROR ******"
        for arg in self.args:
            print arg

class MyError0(MyError):
    '''
    For backward compatibility
    '''
    def write(self):
        """ Writes an error message to standard output. """
        for arg in self.args:
            print arg    


class MyError1(MyError):
    '''
    For backward compatibility
    '''
    pass

class MyError2(MyError):
    '''
    For backward compatibility
    '''
    pass