# ******************************************************
## Revision "$LastChangedDate: 2012-10-17 10:22:07 +0200 (Wed, 17 Oct 2012) $"
## Date "$LastChangedRevision: 261 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/areacell.py $"
# ******************************************************

import math


#radius of the earth in km
R_earth = 6356.751 

def areacell(cellsize,lat_midpoint):
  '''
  http://mathforum.org/library/drmath/view/63767.html
  A = 2*pi*R^2 |sin(lat1)-sin(lat2)| |lon1-lon2|/360
    = (pi/180)R^2 |sin(lat1)-sin(lat2)| |lon1-lon2|
  R is from Gerard.
  Return value is area in km2.  
  '''
  lat1 = math.pi * (lat_midpoint + 0.5 * cellsize)/180.
  lat2 = math.pi * (lat_midpoint - 0.5 * cellsize)/180. 
  return (math.pi/180.) *  R_earth * R_earth * abs(math.sin(lat1) - math.sin(lat2)) * cellsize
