# ******************************************************
## Revision "$LastChangedDate: 2015-05-21 09:28:05 +0200 (Thu, 21 May 2015) $"
## Date "$LastChangedRevision: 505 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/make_fraction.py $"
# ******************************************************

import ascraster

    
def make_fraction(params,source,total,divisionerror_outcome=0.0):
    '''
    Calculates the fraction of the source on the total for each grid cell.
    '''
       
    if params.ldebug: print "Start with calculation of make_fraction."

    fraction = ascraster.duplicategrid(total)
    if (fraction.nodata_value == None):
        fraction.nodata_value = -1

    for icell in range(total.length):
        total_cell = total.get_data(icell,0.0)
        source_cell = source.get_data(icell,0.0)
        try:
            frac = source_cell/total_cell
        except ZeroDivisionError:   
            frac = divisionerror_outcome
            
        # Put result in raster
        fraction.set_data(icell,frac)

    return fraction
    
