# ******************************************************
## Revision "$LastChangedDate: 2013-03-14 17:27:00 +0100 (Thu, 14 Mar 2013) $"
## Date "$LastChangedRevision: 321 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/get_versioninfo.py $"
# ******************************************************

# Import own general modules
from error import MyError
import my_sys
import os

def get_versioninfo(obj,outputdir):
    '''
    Get version (svn) information of directories and return a list of strings.
    '''
    try:
        my_sys.my_system(os.path.join("../../tools/sliksvn/bin","svn") + " info " + str(obj) + " 1> " +\
                         os.path.join(outputdir,"tempuit1.txt") + " 2> " +\
                         os.path.join(outputdir,"tempuit.err"),fatal=1)
        my_sys.my_system(os.path.join("../../tools","grep") + " Rev " +\
                         os.path.join(outputdir,"tempuit1.txt") + " 1> " +\
                         os.path.join(outputdir,"tempuit.txt") + " 2> " +\
                         os.path.join(outputdir,"tempuit.err"),fatal=1)
        list = my_sys.my_readfile(os.path.join(outputdir,"tempuit.txt"))
        my_sys.my_removefile(os.path.join(outputdir,"tempuit.txt"))
        my_sys.my_removefile(os.path.join(outputdir,"tempuit1.txt"))
        my_sys.my_removefile(os.path.join(outputdir,"tempuit.err"))
        list.insert(0,"Directory " +str(obj))
    except (MyError,OSError):
        try:
            #Try another time but with the assumption that the system has svn installed.
            my_sys.my_system("svn info " + str(obj) + " 1> " +\
                             os.path.join(outputdir,"tempuit1.txt") + " 2> " +\
                             os.path.join(outputdir,"tempuit.err"),fatal=1)
            my_sys.my_system("grep Rev " +\
                             os.path.join(outputdir,"tempuit1.txt") + " 1> " +\
                             os.path.join(outputdir,"tempuit.txt") + " 2> " +\
                             os.path.join(outputdir,"tempuit.err"),fatal=1)
            list = my_sys.my_readfile(os.path.join(outputdir,"tempuit.txt"))
            my_sys.my_removefile(os.path.join(outputdir,"tempuit.txt"))
            my_sys.my_removefile(os.path.join(outputdir,"tempuit1.txt"))
            my_sys.my_removefile(os.path.join(outputdir,"tempuit.err"))
            list.insert(0,"Directory " +str(obj))
        except (MyError,OSError): 
            list = []
            list.append("Directory "+str(obj) + " has no version info.")
            # Remove temporary files which are created here 
            if (os.path.isfile(os.path.join(outputdir,"tempuit.txt"))):
                my_sys.my_removefile(os.path.join(outputdir,"tempuit.txt"))
            if (os.path.isfile(os.path.join(outputdir,"tempuit1.txt"))):
                my_sys.my_removefile(os.path.join(outputdir,"tempuit1.txt"))
            if (os.path.isfile(os.path.join(outputdir,"tempuit.err"))):
                my_sys.my_removefile(os.path.join(outputdir,"tempuit.err"))

    return list
