## Revision "$LastChangedDate: 2013-03-08 23:49:13 +0100 (Fri, 08 Mar 2013) $"
## Date "$LastChangedRevision: 319 $"
## Author "$LastChangedBy: arthurbeusen $"
## URL "$HeadURL: https://pbl.sliksvn.com/globalnutrients/generalcode/trunk/get_file_info.py $"

import os, time
from stat import * # ST_SIZE etc

def get_file_info(filename):
    '''
    Gets information of a file and puts it in a list of strings.
    '''
    out = []
    try:
       st = os.stat(filename)
    except IOError:
        print "** WARNING ** Failed to get information about", filename
    else:
        out.append("********************************************")
        out.append("File name: " + os.path.abspath(filename))
        out.append("File size: " + str(st[ST_SIZE]))
        out.append("File modified: " + str(time.asctime(time.localtime(st[ST_MTIME]))))
        out.append(" ")
        #print "File name: " + os.path.abspath(filename)
        #print "File size:", st[ST_SIZE]
        #print "File modified:", time.asctime(time.localtime(st[ST_MTIME]))
    
    return out