#!/bin/csh -f

#===============================================================================
#  ocn.abio_dic_dic14.setup.csh : perform setup tasks for abio_dic_dic14 module
#
#  recognized commands, possibly with arguments, are
#    set_nt         nt_filename
#    namelist       pop_in_filename
#    set_tavg_nml
#    tavg_contents  tavg_contents_filename my_stream
#    prestage       res_dpt_dir res_indpt_dir
#    document       pop2_document
#    ccsm_prestage  ccsm_prestage_file
#
#  SVN:$Id: ocn.abio_dic_dic14.setup.csh 22461 2010-04-19 17:13:30Z njn01 $
#
#===============================================================================

if ($#argv < 1) then
   echo ocn.abio_dic_dic14.setup.csh : command argument missing
   exit 1
endif

#===============================================================================
#  set IC files
#===============================================================================
set relpath = ocn/pop/$OCN_GRID
if ($OCN_GRID == gx3v7) then
   set IC_file  = $DIN_LOC_ROOT/$relpath/ic/ecosys_jan_IC_gx3v7_20100514.nc
   set IC_fmt   = nc
else if ($OCN_GRID == gx1v6) then
   set IC_file  = $DIN_LOC_ROOT/$relpath/ic/ecosys_jan_IC_gx1v6_20100514.nc
   set IC_fmt   = nc
else
   echo OCN_GRID=$OCN_GRID not supported by ecosystem module
   exit 2
endif

if ($runtype == startup) then
  if ($OCN_PRESTAGE == TRUE) then
   set IC_file_nml = $INPUT/$IC_file:t
  else
   set IC_file_nml = $IC_file
   endif
else
   set IC_file_nml = same_as_TS
 endif
 

#===============================================================================
#  set module name, which is required for tavg_nml
#  module name must match the name of this setup script
#===============================================================================
set module = abio_dic_dic14


#===============================================================================

set command = $1

if ($command == set_nt) then

   echo ocn.abio_dic_dic14.setup.csh : setting nt                                           >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   if ($#argv < 2) then
      echo nt_filename argument missing
      exit 3
   endif

   set nt_filename = $2

   if !(-f $nt_filename) then
      echo nt_filename = $nt_filename does not exist
      exit 3
   endif

   @ nt_in = `cat $nt_filename`
   @ nt_in += 2
   echo $nt_in >! $nt_filename

else if ($command == namelist) then

   echo ocn.abio_dic_dic14.setup.csh : setting namelist options                             >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML


   if ($#argv < 2) then
      echo pop_in_filename argument missing
      exit 4
   endif

   set pop_in_filename = $2

   if !(-f $pop_in_filename) then
      echo pop_in_filename = $pop_in_filename does not exist
      exit 4
   endif
   
   if ($OCN_CO2_FLUX_OCMIP_BUG_FIX == TRUE) then
      set abio_locmip_k1_k2_bug_fix = .true.
   else
      set abio_locmip_k1_k2_bug_fix = .false.
   endif

   if ($runtype == startup) then
      set abio_use_nml_surf_vals = .true.
   else
      set abio_use_nml_surf_vals = .false.
   endif
   
   set init_abio_dic_dic14_option = ccsm_$runtype

   cat >> $pop_in_filename << EOF

&abio_dic_dic14_nml
   init_abio_dic_dic14_option           = '$init_abio_dic_dic14_option'  
   init_abio_dic_dic14_init_file        = '$IC_file_nml'
   init_abio_dic_dic14_init_file_fmt    = '$IC_fmt'
   abio_tracer_init_ext(1)%mod_varname  = 'ABIO_DIC'
   abio_tracer_init_ext(1)%scale_factor = 1.025 
   abio_tracer_init_ext(1)%file_varname = 'DIC'
   abio_tracer_init_ext(2)%mod_varname  = 'ABIO_DIC14'
   abio_tracer_init_ext(2)%scale_factor = 1.025 
   abio_tracer_init_ext(2)%file_varname = 'DIC'
   abio_surf_avg_dic_const              = 1944.0
   abio_surf_avg_dic14_const            = 1944.0
   abio_use_nml_surf_vals               = $abio_use_nml_surf_vals
   abio_locmip_k1_k2_bug_fix            = $abio_locmip_k1_k2_bug_fix
   abio_comp_surf_avg_freq_opt          = 'never'
   abio_comp_surf_avg_freq              = 1
   abio_atm_d14c_filename(1)            = '/glade/u/home/ajahn/ForcingFiles/c14sth_HG09.dat'
   abio_atm_d14c_filename(2)            = '/glade/u/home/ajahn/ForcingFiles/c14equ_HG09.dat'
   abio_atm_d14c_filename(3)            = '/glade/u/home/ajahn/ForcingFiles/c14nth_HG09.dat'
   abio_atm_co2_filename                = '/glade/u/home/ajahn/ForcingFiles/co2_HG09.dat'
   abio_atm_co2_d14c_opt                = 'const'
   abio_atm_co2_const                   = 278.0
   abio_atm_d14c_const                  = 0.0
/
EOF

 
else if ($command == set_tavg_nml) then

  #-------------------------------------------------------------------------------------
  # if there is no module-related tavg output, or all tavg output is sent to the base 
  # model output streams, then set n_tavg_streams_tracer = 0
  #-------------------------------------------------------------------------------------
    set n_tavg_streams_tracer = 0
cat >&! $POP2_DOCDIR/$module.tavg << EOF
n_tavg_streams_tracer =  $n_tavg_streams_tracer
EOF

else if ($command == tavg_contents) then

   echo ocn.abio_dic_dic14.setup.csh : setting tavg_contents variables                      >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   if ($#argv < 3) then
      echo tavg_contents_filename argument missing
      exit 5
   endif

   set tavg_contents_filename = $2

   if !(-f $tavg_contents_filename) then
      echo tavg_contents_filename = $tavg_contents_filename does not exist
      exit 5
   endif

   @ my_stream = $3
   if ($my_stream < 1) then
      echo invalid my_stream number  ($my_stream)
      exit 5
   endif

   #------------------------------------------------------------------------------------
   # For now, set streams manually. You must only set as many streams as are declared
   #  in the tavg_nml section. For example, if there are three streams:
   #  @ s1 = $my_stream
   #  @ s2 = $s1 + 1
   #  @ s3 = $s2 + 1
   #------------------------------------------------------------------------------------

   @ s1 = 1   # use base-model stream 1

   cat >> $tavg_contents_filename << EOF
$s1  ABIO_DIC
$s1  ABIO_DIC14 
$s1  ABIO_D14Cocn
$s1  ABIO_CO2_IFRAC
$s1  ABIO_CO2_XKW
$s1  ABIO_CO2_ATM_PRESS
$s1  ABIO_pCO2
$s1  ABIO_CO2_SCHMIDT
$s1  ABIO_CO2_PV
$s1  ABIO_pCO2SURF
$s1  ABIO_DCO2STAR
$s1  ABIO_CO2STAR
$s1  ABIO_DpCO2
$s1  ABIO_D14Catm
$s1  FG_ABIO_DIC14
$s1  FG_ABIO_DIC
$s1  ABIO_ALK_SURF
$s1  ABIO_PH_SURF
$s1  FvICE_ABIO_DIC
$s1  FvPER_ABIO_DIC
$s1  ABIO_DIC_SURF
$s1  J_ABIO_DIC
$s1  Jint_ABIO_DIC
$s1  STF_ABIO_DIC
$s1  RESID_ABIO_DIC 
$s1  FvICE_ABIO_DIC14
$s1  FvPER_ABIO_DIC14
$s1  ABIO_DIC14_SURF
$s1  J_ABIO_DIC14
$s1  Jint_ABIO_DIC14
$s1  STF_ABIO_DIC14
$s1  RESID_ABIO_DIC14 
EOF

#-------------------------------------------------------------------------------------
# Add optional tracer budget terms
#-------------------------------------------------------------------------------------
#if ($OCN_TAVG_TRACER_BUDGET == TRUE) then
#cat >> $tavg_contents_filename << EOF
#$s1  IAGE_RESET_TEND
#$s1  DIA_IMPVF_IAGE
#$s1  HDIFE_IAGE
#$s1  HDIFN_IAGE
#$s1  HDIFB_IAGE
#$s1  UE_IAGE
#$s1  VN_IAGE
#$s1  WT_IAGE
#EOF
#endif


else if ($command == prestage) then

   echo ocn.abio_dic_dic14.setup.csh : prestaging data files                                >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML


else if ($command == document) then

   echo ocn.abio_dic_dic14.setup.csh : documenting inputdata files                          >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML


else if ($command == ccsm_prestage) then

  #echo ocn.abio_dic_dic14.setup.csh : writing ccsm prestaging information                  >> $POP2_BLDNML


else

   echo ocn.abio_dic_dic14.setup.csh : unrecognized command $command                        >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   exit 2

endif
