#!/bin/csh -f

#===============================================================================
#  ocn.Ciso.setup.csh : perform setup tasks for ecosys_Ciso module
#
#  recognized commands, possibly with arguments, are
#    set_nt         nt_filename
#    namelist       pop_in_filename
#    set_tavg_nml
#    tavg_contents  tavg_contents_filename my_stream
#    prestage       res_dpt_dir res_indpt_dir
#    document       pop2_document_files
#    ccsm_prestage  ccsm_prestage_file
#
#  CVS:$Id: ocn.Ciso.setup.csh 2448 2006-11-14 21:01:38Z njn01 $ 
#  CVS:$Name$ 
#
#===============================================================================

if ($#argv < 1) then
   echo ocn.Ciso.setup.csh : command argument missing
   exit 1
endif

#===============================================================================
#  set IC and forcing files
#===============================================================================

if (($OCN_TRANSIENT != unset) && ($OCN_TRANSIENT != 1850-2000)) then
   echo OCN_TRANSIENT=$OCN_TRANSIENT not supported by ecosystem module
   exit 2
endif

set relpath = ocn/pop/$OCN_GRID
if ($OCN_GRID == gx3v7) then

   set IC_file  = $DIN_LOC_ROOT/$relpath/ic/ecosys_jan_IC_gx3v7_20100514.nc
  
else if ($OCN_GRID == gx1v6) then

   set IC_file  = $DIN_LOC_ROOT/$relpath/ic/ecosys_jan_IC_gx1v6_20100514.nc

else

   echo OCN_GRID=$OCN_GRID not supported by ecosystem module
   exit 2

endif

set IC_fmt   = nc
set DI13C_scale_factor = 1.025
set DI14C_scale_factor = 0.9225
set other_13C_scale_factor = 1.0
set other_14C_scale_factor = 1.0

if ($runtype == startup) then
  if ($OCN_PRESTAGE == TRUE) then
   set IC_file_nml = $INPUT/$IC_file:t
  else
   set IC_file_nml = $IC_file
  endif
else
   set IC_file_nml = same_as_TS
endif


#===============================================================================
#  set module name, which is required for tavg_nml
#  module name must match the name of this setup script
#===============================================================================
set module = Ciso

#===============================================================================

set command = $1

if ($command == set_nt) then

   echo ocn.Ciso.setup.csh : setting nt                                        >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   if ($#argv < 2) then
      echo nt_filename argument missing
      exit 3
   endif

   set nt_filename = $2

   if !(-f $nt_filename) then
      echo nt_filename = $nt_filename does not exist
      exit 3
   endif

   @ nt_in = `cat $nt_filename`
   @ nt_in += 14
   echo $nt_in > $nt_filename

else if ($command == namelist) then

   echo ocn.Ciso.setup.csh : setting namelist options                          >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   if ($#argv < 2) then
      echo pop_in_filename argument missing
      exit 4
   endif

   set pop_in_filename = $2

   if !(-f $pop_in_filename) then
      echo pop_in_filename = $pop_in_filename does not exist
      exit 4
   endif

   if ($OCN_CO2_FLUX_OCMIP_BUG_FIX == TRUE) then
      set Ciso_locmip_k1_k2_bug_fix = .true.
   else
      set Ciso_locmip_k1_k2_bug_fix = .false.
   endif

   if ($runtype == startup) then
      set Ciso_use_nml_surf_vals = .true.
   else
      set Ciso_use_nml_surf_vals = .false.
   endif

   # note: $runtype is the ccsm script-level variable;
   #       ccsm_$runtype is the pop2 model-level variable
   set init_ecosys_Ciso_option = ccsm_$runtype

   cat >> $pop_in_filename << EOF

&ecosys_Ciso_nml
   init_ecosys_Ciso_option              = '$init_ecosys_Ciso_option'
   init_ecosys_Ciso_init_file           = '$IC_file_nml'
   init_ecosys_Ciso_init_file_fmt       = '$IC_fmt'
   Ciso_tracer_init_ext(1)%file_varname = 'DIC'
   Ciso_tracer_init_ext(1)%mod_varname  = 'DI13C'
   Ciso_tracer_init_ext(1)%scale_factor = $DI13C_scale_factor
   Ciso_tracer_init_ext(2)%file_varname = 'DOC'
   Ciso_tracer_init_ext(2)%mod_varname  = 'DO13C'
   Ciso_tracer_init_ext(2)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(3)%file_varname = 'spC'
   Ciso_tracer_init_ext(3)%mod_varname  = 'sp13C'
   Ciso_tracer_init_ext(3)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(4)%file_varname = 'spCaCO3'
   Ciso_tracer_init_ext(4)%mod_varname  = 'spCa13CO3'
   Ciso_tracer_init_ext(4)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(5)%file_varname = 'diatC'
   Ciso_tracer_init_ext(5)%mod_varname  = 'diat13C'
   Ciso_tracer_init_ext(5)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(6)%file_varname = 'zooC'
   Ciso_tracer_init_ext(6)%mod_varname  = 'zoo13C'
   Ciso_tracer_init_ext(6)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(7)%file_varname = 'diazC'
   Ciso_tracer_init_ext(7)%mod_varname  = 'diaz13C'
   Ciso_tracer_init_ext(7)%scale_factor = $other_13C_scale_factor
   Ciso_tracer_init_ext(8)%file_varname = 'DIC'
   Ciso_tracer_init_ext(8)%mod_varname  = 'DI14C'
   Ciso_tracer_init_ext(8)%scale_factor = $DI14C_scale_factor
   Ciso_tracer_init_ext(9)%file_varname = 'DOC'
   Ciso_tracer_init_ext(9)%mod_varname  = 'DO14C'
   Ciso_tracer_init_ext(9)%scale_factor = $other_14C_scale_factor
   Ciso_tracer_init_ext(10)%file_varname = 'spC'
   Ciso_tracer_init_ext(10)%mod_varname  = 'sp14C'
   Ciso_tracer_init_ext(10)%scale_factor = $other_14C_scale_factor
   Ciso_tracer_init_ext(11)%file_varname = 'spCaCO3'
   Ciso_tracer_init_ext(11)%mod_varname  = 'spCa14CO3'
   Ciso_tracer_init_ext(11)%scale_factor = $other_14C_scale_factor
   Ciso_tracer_init_ext(12)%file_varname = 'diatC'
   Ciso_tracer_init_ext(12)%mod_varname  = 'diat14C'
   Ciso_tracer_init_ext(12)%scale_factor = $other_14C_scale_factor
   Ciso_tracer_init_ext(13)%file_varname = 'zooC'
   Ciso_tracer_init_ext(13)%mod_varname  = 'zoo14C'
   Ciso_tracer_init_ext(13)%scale_factor = $other_14C_scale_factor
   Ciso_tracer_init_ext(14)%file_varname = 'diazC'
   Ciso_tracer_init_ext(14)%mod_varname  = 'diaz14C'
   Ciso_tracer_init_ext(14)%scale_factor = $other_14C_scale_factor
   Ciso_locmip_k1_k2_bug_fix            = $Ciso_locmip_k1_k2_bug_fix
   Ciso_atm_d13c_opt                    = 'const'
   Ciso_atm_d13c_const                  = -6.379
   Ciso_atm_d14c_opt                    = 'const'
   Ciso_atm_d14c_const                  = 0.0
   Ciso_tadvect_ctype                   = 'base_model'
   Ciso_lmarginal_seas                  = .true.
   Ciso_lsource_sink                    = .true.
   Ciso_comp_surf_avg_freq_opt          = 'never'
   Ciso_comp_surf_avg_freq              = 1
   Ciso_use_nml_surf_vals               = $Ciso_use_nml_surf_vals
   Ciso_surf_avg_di13c_const            = 1944.0 
   Ciso_atm_d13c_filename               = '/glade/u/home/ajahn/ForcingFiles/c13_HG09.dat'
   Ciso_surf_avg_di14c_const            = 1944.0
   Ciso_atm_d14c_filename(1)            = '/glade/u/home/ajahn/ForcingFiles/c14sth_HG09.dat'
   Ciso_atm_d14c_filename(2)            = '/glade/u/home/ajahn/ForcingFiles/c14equ_HG09.dat'
   Ciso_atm_d14c_filename(3)            = '/glade/u/home/ajahn/ForcingFiles/c14nth_HG09.dat'
   Ciso_fract_factors                   = 'Rau'
EOF


   cat >> $pop_in_filename << EOF
   Ciso_lecovars_full_depth_tavg = .false.
/

&ecosys_parms_nml
/
EOF

else if ($command == set_tavg_nml) then

  #-------------------------------------------------------------------------------------
  # if there is no module-related tavg output, set n_tavg_streams_tracer = 0
  #-------------------------------------------------------------------------------------
    set n_tavg_streams_tracer = 2
cat >&! $POP2_DOCDIR/$module.tavg << EOF
n_tavg_streams_tracer =  $n_tavg_streams_tracer
EOF

  #-------------------------------------------------------------------------------------
  # optional: the following definitions are necessary only if n_tavg_streams_tracer > 0 
  #           number of settings must agree with the value of n_tavg_streams_tracer
  #-------------------------------------------------------------------------------------
  if ($n_tavg_streams_tracer > 0) then
    cat >> $POP2_DOCDIR/$module.tavg << EOF
tavg_freq_opt             = 'nday'          'nyear'
tavg_freq                 =  1              1
tavg_stream_filestrings   = 'ecosys.nday1'  'ecosys.nyear1'
tavg_file_freq_opt        = 'nmonth'        'nyear'
tavg_file_freq            =  1              1
tavg_start_opt            = 'nstep'         'nstep'
tavg_start                =  0              0
tavg_fmt_in               = 'nc'            'nc'
tavg_fmt_out              = 'nc'            'nc'
ltavg_has_offset_date     = .false.         .false.
tavg_offset_years         =  1              1
tavg_offset_months        =  1              1
tavg_offset_days          =  2              2
ltavg_one_time_header     = .false.         .false.
EOF
  endif  #n_tavg_streams_tracer

else if ($command == tavg_contents) then

   echo ocn.Ciso.setup.csh : setting tavg_contents variables                   >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   if ($#argv < 3) then
      echo tavg_contents_filename argument missing
      exit 5
   endif

   set tavg_contents_filename = $2

   if !(-f $tavg_contents_filename) then
      echo tavg_contents_filename = $tavg_contents_filename does not exist
      exit 5
   endif

   @ my_stream = $3
   if ($my_stream < 1) then
      echo invalid my_stream number  ($my_stream)
      exit 5
   endif

   #------------------------------------------------------------------------------------
   # For now, set streams manually. You must only set as many streams as are declared
   #  in the tavg_nml section. For example, if there are three streams:
   #  @ s1 = $my_stream
   #  @ s2 = $s1 + 1
   #  @ s3 = $s2 + 1
   #------------------------------------------------------------------------------------

      @ s1 = 1             # use the base-model stream 1
      @ s2 = $my_stream    # use an ecosystem-defined stream
      @ s3 = $s2 + 1       # use an ecosystem-defined stream

   cat >> $tavg_contents_filename << EOF
$s1  CISO_d14C_sp
$s1  CISO_d13C_sp
$s1  CISO_d14C_diaz
$s1  CISO_d13C_diaz
$s1  CISO_d14C_diat
$s1  CISO_d13C_diat
$s1  CISO_spCaCO3_d14C   
$s1  CISO_zooC_d14C      
$s1  CISO_DOC_d14C         
$s1  CISO_DIC_d14C        
$s1  CISO_spCaCO3_d13C    
$s1  CISO_zooC_d13C       
$s1  CISO_DOC_d13C         
$s1  CISO_DIC_d13C           
$s1  CISO_FG_14CO2
$s1  CISO_FG_as_14CO2
$s1  CISO_FG_sa_14CO2
$s1  CISO_FG_d14C
$s1  CISO_D14C_atm
$s1  CISO_R14C_DIC_surf
$s1  CISO_R14C_atm
$s1  CISO_PO14C_FLUX_IN
$s1  CISO_PO14C_PROD
$s1  CISO_PO14C_REMIN
$s1  CISO_DO14C_prod
$s1  CISO_DO14C_remin
$s1  CISO_Ca14CO3_FLUX_IN
$s1  CISO_Ca14CO3_PROD
$s1  CISO_Ca14CO3_REMIN
$s1  CISO_Ca14CO3_form
$s1  CISO_photo14C_TOT
$s1  CISO_Ca14CO3_form_zint
$s1  CISO_photo14C_TOT_zint
$s1  CISO_Jint_14Ctot
$s1  CISO_Jint_100m_14Ctot
$s1  CISO_photo14C_sp
$s1  CISO_photo14C_diat
$s1  CISO_photo14C_diaz
$s1  CISO_photo14C_sp_zint
$s1  CISO_photo14C_diat_zint
$s1  CISO_photo14C_diaz_zint
$s1  FvPER_DI14C
$s1  FvICE_DI14C
$s1  DI14C
$s1  J_DI14C
$s1  DO14C
$s1  sp14C
$s1  spCa14CO3
$s1  diat14C
$s1  zoo14C
$s1  diaz14C
$s1  Jint_100m_DI14C
$s1  Jint_100m_DO14C
$s1  tend_zint_100m_DI14C
$s1  tend_zint_100m_DO14C
$s2  sp14C_zint_100m
$s2  spCa14CO3_zint_100m
$s2  diaz14C_zint_100m
$s2  diat14C_zint_100m
$s2  zoo14C_zint_100m
$s3  UE_DO14C
$s3  VN_DO14C
$s3  WT_DO14C
$s3  HDIFE_DO14C
$s3  HDIFN_DO14C
$s3  HDIFB_DO14C
$s3  UE_DI14C
$s3  VN_DI14C
$s3  WT_DI14C
$s3  KPP_SRC_DI14C
$s3  DIA_IMPVF_DI14C
$s3  HDIFE_DI14C
$s3  HDIFN_DI14C
$s3  HDIFB_DI14C
$s1  CISO_FG_13CO2
$s1  CISO_FG_as_13CO2
$s1  CISO_FG_sa_13CO2
$s1  CISO_FG_CO2
$s1  CISO_FG_as_CO2
$s1  CISO_FG_sa_CO2
$s1  CISO_FG_d13C
$s1  CISO_D13C_atm
$s1  CISO_R13C_DIC_surf
$s1  CISO_R13C_atm
$s1  CISO_eps_aq_g_surf
$s1  CISO_eps_dic_g_surf
$s1  CISO_eps_aq_g
$s1  CISO_eps_dic_g
$s1  CISO_PO13C_FLUX_IN
$s1  CISO_PO13C_PROD
$s1  CISO_PO13C_REMIN
$s1  CISO_DO13C_prod
$s1  CISO_DO13C_remin
$s1  CISO_Ca13CO3_FLUX_IN
$s1  CISO_Ca13CO3_PROD
$s1  CISO_Ca13CO3_REMIN
$s1  CISO_Ca13CO3_form
$s1  CISO_photo13C_TOT
$s1  CISO_Ca13CO3_form_zint
$s1  CISO_photo13C_TOT_zint
$s1  CISO_Jint_13Ctot
$s1  CISO_Jint_100m_13Ctot
$s1  CISO_photo13C_sp
$s1  CISO_photo13C_diat
$s1  CISO_photo13C_diaz
$s1  CISO_photo13C_sp_zint
$s1  CISO_photo13C_diat_zint
$s1  CISO_photo13C_diaz_zint
$s1  CISO_eps_autotroph_sp
$s1  CISO_eps_autotroph_diat
$s1  CISO_eps_autotroph_diaz
$s1  CISO_mui_to_co2star_sp
$s1  CISO_mui_to_co2star_diat
$s1  CISO_mui_to_co2star_diaz
$s1  CISO_POC_PROD
$s1  CISO_POC_REMIN
$s1  CISO_POC_FLUX_IN
$s1  CISO_CaCO3_REMIN
$s1  CISO_CaCO3_PROD
$s1  CISO_CaCO3_FLUX_IN
$s1  FvPER_DI13C
$s1  FvICE_DI13C
$s1  DI13C
$s1  CISO_FRAC_CO3
$s1  J_DI13C
$s1  DO13C
$s1  sp13C
$s1  spCa13CO3
$s1  diat13C
$s1  zoo13C
$s1  diaz13C
$s1  Jint_100m_DI13C
$s1  Jint_100m_DO13C
$s1  tend_zint_100m_DI13C
$s1  tend_zint_100m_DO13C
$s2  sp13C_zint_100m
$s2  spCa13CO3_zint_100m
$s2  diaz13C_zint_100m
$s2  diat13C_zint_100m
$s2  zoo13C_zint_100m
$s3  UE_DO13C
$s3  VN_DO13C
$s3  WT_DO13C
$s3  HDIFE_DO13C
$s3  HDIFN_DO13C
$s3  HDIFB_DO13C
$s3  UE_DI13C
$s3  VN_DI13C
$s3  WT_DI13C
$s3  KPP_SRC_DI13C
$s3  DIA_IMPVF_DI13C
$s3  HDIFE_DI13C
$s3  HDIFN_DI13C
$s3  HDIFB_DI13C
EOF



else if ($command == prestage) then

 if ($OCN_PRESTAGE == TRUE) then

   echo ocn.Ciso.setup.csh : prestaging data files                             >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

  
 else

   echo ocn.Ciso.setup.csh : data files are not being prestaged                >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

 endif

else if ($command == document) then

   echo ocn.Ciso.setup.csh : documenting inputdata files                       >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

else if ($command == ccsm_prestage) then

#  echo ocn.Ciso.setup.csh : writing ccsm prestaging information               >> $POP2_BLDNML
#  echo ------------------------------------------------------------------------ >> $POP2_BLDNML

else
   echo ocn.Ciso.setup.csh : unrecognized command $command                     >> $POP2_BLDNML
   echo ------------------------------------------------------------------------ >> $POP2_BLDNML

   exit 9

endif
