#!/bin/bash -ve

DTs=(3600 3600 3600 1800 900 450 225)
#DTs=(1800 900 450 225)

i=0
for num in 2 3 4 5; do # 6 7 8; do
#    for type in '' _nonOrthog; do
    for type in _new; do
        case=${num}${type}
        mkdir $case
        cp -r blank/* $case
        
        sed 's/DELTAT/'${DTs[$i]}'/g' blank/system/controlDict \
            > $case/system/controlDict
            
        # mesh generation - take the dual from triangle centroids
        cp -r $num/constant/dualMesh/polyMesh $case/constant
        rm $case/constant/polyMesh/*Centres
        polyDualPatch -case $case
        rm -r $case/constant/polyMesh
        mv $case/0/dualMesh/polyMesh $case/0
        
        # take the dual 2n+1 times to smooth
        for id in 1 2 3 4 5 6 7 8 9 10; do
            rm $case/0/polyMesh/*Centres
            polyDualPatch -case $case
            rm -r $case/0/polyMesh
            mv $case/0/dualMesh/polyMesh $case/0
        done
        polyDualPatch -case $case
        
        # calculate the mesh structures
        meshStructure -case $case '1(originalPatch)'
        meshStructure -case $case -region dualMesh '1(originalPatch)'

        # calculate the orthogonality and other mesh diagnostics
        orthogonality -case $case > $case/orthogLog
    
        # move the mesh to constant
        mv $case/0/dualMesh/* $case/constant/dualMesh
        rmdir $case/0/dualMesh
        mv $case/0/* $case/constant
        rmdir $case/0

        # plot both meshes, orthogonality and skewness (for coarse meshes)
        if [ "$num" -le 5 ] ; then
            plotPatchData -case $case orthogonality
            plotPatchData -case $case skewness -region dualMesh
            cat $case/constant/skewness.eps \
                >> $case/constant/orthogonality.eps
            rm $case/constant/skewness.eps
            gv $case/constant/orthogonality.eps &
        fi
        
        # create initial conditions (and plot if on a coarse mesh)
        setWilliSteady -case $case
        if [ "$num" -le 5 ] ; then
            plotPatchData -case $case hU
            gv $case/0/hU.eps &
        fi
        
        # setup different H operators for this run
        mkdir $case/save
        Hs=(diagonal Dubos)
        if [ "$type" != '' ] ; then
            Hs=(asymmetric Dubos)
        fi
        for H in ${Hs[*]}; do
            subCase=$case/save/dt${DTs[$i]}_${H}H_CLUSTPV_CLUSTh
            mkdir $subCase
            ln -s ../../0 $subCase/0
            ln -s ../../constant $subCase/constant
            cp -r $case/system $subCase
            sed 's/TYPE/'$H'/g' blank/system/fvSolution \
                > $subCase/system/fvSolution
        done 
    done 
    let i=$i+1
done

