#!/bin/bash -ve

DTs=(3600 3600 1800 900 450 225)
#DTs=(1800 900 450 225)

i=0
for num in 3 4 5 6 7 8; do
#    for type in '' _nonOrthog; do
    for type in  _Cd; do
        case=${num}${type}
        mkdir $case
        cp -r blank/* $case
        
        sed 's/DELTAT/'${DTs[$i]}'/g' blank/system/controlDict \
            > $case/system/controlDict
        sed 's/gridn.out/grid'${num}'.out/g' \
            blank/system/VoronoiSphereMeshDict \
                > $case/system/VoronoiSphereMeshDict
            
        # mesh generation
        VoronoiSphereMesh -case $case
        if [ "$type" = _nonOrthog ] ; then
            rm $case/0/polyMesh/cellCentres $case/0/polyMesh/faceCentres
        fi
        polyDualPatch -case $case
        # for centroidal dual (_Cd) remove dual cell centres and re-calculate
        if [ "$type" = _Cd ] ; then
            rm $case/0/dualMesh/polyMesh/*Centres
            rm -r $case/0/polyMesh
            mv $case/0/dualMesh/polyMesh $case/0
            polyDualPatch -case $case
            rm -r $case/0/polyMesh
            mv $case/0/dualMesh/polyMesh $case/0
            polyDualPatch -case $case
        fi
        
        # calculate the mesh structures
        meshStructure -case $case '1(originalPatch)'
        meshStructure -case $case -region dualMesh '1(originalPatch)'

        # calculate the orthogonality and other mesh diagnostics
        orthogonality -case $case > $case/orthogLog
    
        # move the mesh to constant
        mv $case/0/dualMesh/* $case/constant/dualMesh
        rmdir $case/0/dualMesh
        mv $case/0/* $case/constant
        rmdir $case/0

        # plot both meshes, orthogonality and skewness (for coarse meshes)
        if [ "$num" -le 5 ] ; then
            plotPatchData -case $case orthogonality
            plotPatchData -case $case skewness -region dualMesh
            cat $case/constant/skewness.eps \
                >> $case/constant/orthogonality.eps
            rm $case/constant/skewness.eps
            gv $case/constant/orthogonality.eps &
        fi
        
        # create initial conditions (and plot if on a coarse mesh)
        setWilliSteady -case $case
        if [ "$num" -le 5 ] ; then
            plotPatchData -case $case hU
            gv $case/0/hU.eps &
        fi
        
        # setup different H operators for this run
        mkdir $case/save
        Hs=(diagonal Dubos)
        if [ "$type" != '' ] ; then
            Hs=(asymmetric Dubos)
        fi
        for H in ${Hs[*]}; do
            subCase=$case/save/dt${DTs[$i]}_${H}H_CLUSTPV_CLUSTh
            mkdir $subCase
            ln -s ../../0 $subCase/0
            ln -s ../../constant $subCase/constant
            cp -r $case/system $subCase
            sed 's/TYPE/'$H'/g' blank/system/fvSolution \
                > $subCase/system/fvSolution
        done 
    done 
    let i=$i+1
done

for dir in */save/*diagonalH*; do
    #case=`filename $dir`
    newDir=`echo $dir | sed 's/diagonal/asymmetric/g'`
    echo $dir $newDir
    ln -s ../../$dir $newDir
done

