!
! File entails subroutines needed to calculated gravitational sinking of 
! phytoplankton and deritus:
!
!	- subroutine REcoM_sinking
!	- subroutine Depth_calculations
!
!===============================================================================
! Subroutine calculating sinking of Detritus, diatoms and possibly phy
!===============================================================================
subroutine REcoM_sinking(dt,Nn,wF,dzF,recipDzF,C,sink,zF)
  use REcoM_params
  use REcoM_constants
  
  Real(kind=8)                 :: dt
  Integer                      :: Nn
  Integer		               :: k,km1,km2,kp1
  Real(kind=8),dimension(Nn)   :: C
  Real(kind=8),dimension(Nn+1) :: wF            ! Vertical velocity for fluxes
  Real(kind=8)                 :: wLoc,wM,wP
  Real(kind=8)                 :: Rjp,Rj,Rjm
  Real(kind=8),dimension(Nn)   :: dzF,recipdzF
  Real(kind=8)                 :: cfl, d0, d1, thetaP, thetaM, psiP, psiM
  Real(kind=8)                 :: onesixth	= 	1.d0/6.d0
  Real(kind=8)                 :: wflux
  Real(kind=8)                 :: wfluxkp1
  Real(kind=8),dimension(Nn)   :: sink	
  Real(kind=8),dimension(Nn+1) :: zF                   ! [m] Depth of fluxes
  Real(8),dimension(Nn+1)	   :: new_wF
  
  if (allow_var_sinking) then
    do k=one,Nn+one
      new_wF(k)= Vdet_a * abs(zF(k)) + wF(k) ! Applies to phy, dia and det.	        
    enddo
  else
    new_wF = wF
  endif
  
  wfluxkp1   = 0.d0
  wflux      = 0.d0	
	
  do k=Nn,2,-1
    km1      = max(1,k-1)
    km2      = max(1,k-2)
    kp1      = min(Nn,k+1)
    wLoc     = -new_wF(k)
    wP       = wLoc + abs(wLoc)
    wM       = wLoc - abs(wLoc)
    Rjp	   = C(k)	-	C(kp1)
    Rj       = C(km1)-	C(k)
    Rjm	   = C(km2)-	C(km1)	
    cfl      = abs(wLoc * dt * recipDzF(k))
    d0       = (2.d0 - cfl)*(1.d0 - cfl)*onesixth
    d1       = (1.d0 - cfl*cfl)*onesixth	
    thetaP   = Rjm/(1.d-20+Rj)
    psiP     = d0 + d1*thetaP
    psiP     = max(0.d0, min(min(1.d0,psiP), &
                 (1.d0-cfl)/(1.d-20+cfl)*thetaP))
    thetaM   = Rjp/(1.d-20 + Rj)	
    psiM     = d0 + d1*thetaM
    psiM     = max(0.d0, min(min(1.d0,psiM), &
		(1.d0-cfl)/(1.d-20-cfl)*thetaM))
    wflux    = ( 0.5*wP*(C(k)  + psiM * Rj)+ &
		0.5*wM*(C(km1)+ psiP * Rj))
    sink(k)  =	-(wflux-wfluxkp1)*recipDzF(k)*dt
    wfluxkp1 =	wflux	
  enddo
  k          = 1
  wflux      = 0
  sink(k)    = -(wflux-wfluxkp1)*recipDzF(k)*dt
	
end subroutine REcoM_sinking

!===============================================================================
! Subroutine for calculating flux-depth and thickness of control volumes
!===============================================================================
subroutine Depth_calculations(zNodes,Nn,zF,dzF,recipdzF,wF)
  use REcoM_params
  use REcoM_constants
  implicit none

! Input
  Integer,                     intent(in)  :: Nn	     ! Total number of nodes
  Real(kind=8),dimension(Nn),  intent(in)  :: zNodes	     ! Depth of nodes
! Output
  real(kind=8),dimension(Nn+1),intent(out) :: zF             ! [m] Depth of fluxes
  real(kind=8),dimension(Nn),  intent(out) :: dzF            ! [m] Thickness of control volumes  
  real(kind=8),dimension(Nn),  intent(out) :: recipdzF       ! [1/m] 
  real(kind=8),dimension(Nn+1,3),intent(out) :: wF           ! [m/day] Velocities of fluxes at the border of the control volumes
  real(kind=8),dimension(Nn,3)               :: wNodes       ! [m/day] Vertical velocities at each node
  Integer                                  :: k              ! Index for depth                     
!-------------------------------------------------------------------------------
! Sinking velocities
  wNodes(:,ivphy) = VPhy  
  wNodes(:,ivdia) = VDia
  wNodes(:,ivdet) = VDet
  
  wNodes(1,:)     = 0.d0
  !wNodes(Nn,:)    = 0.d0
  wF(1,:)         = 0.d0
  wF(Nn+1,:)      = 0.d0
!-------------------------------------------------------------------------------
! Depth of the borders of the control volumes are calculated

  zF(1)		  = zNodes(1)
  zF(Nn+1)	  = zNodes(Nn)
  do k=one,Nn-one
    zF(k+1)	  = zNodes(k)+0.5*(zNodes(k+1)-zNodes(k))
    wF(k+1,ivphy) = 0.5 * (wNodes(k,ivphy) + wNodes(k+1,ivphy)) 
    wF(k+1,ivdia) = 0.5 * (wNodes(k,ivdia) + wNodes(k+1,ivdia))
    wF(k+1,ivdet) = 0.5 * (wNodes(k,ivdet) + wNodes(k+1,ivdet))
  enddo
!-------------------------------------------------------------------------------
! Thickness of control volumes are calculated (distance between fluxes)

  do k = one,Nn
    dzF(k)	=	zF(k)-zF(k+1)
    recipDzF(k)	=	1.d0/dzF(k)
  end do

end subroutine Depth_calculations

